/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.sctp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineFactory;
import io.netty.channel.Channels;
import io.netty.channel.sctp.SctpServerSocketChannelFactory;
import io.netty.example.sctp.SctpServerHandler;
import io.netty.handler.execution.ExecutionHandler;
import io.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class SctpServer {
    private final int port;

    public SctpServer(int port) {
        this.port = port;
    }

    public void run() {
        ServerBootstrap bootstrap = new ServerBootstrap(new SctpServerSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        final ExecutionHandler executionHandler = new ExecutionHandler(new OrderedMemoryAwareThreadPoolExecutor(16, 0x100000L, 0x100000L));
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline(executionHandler, new SctpServerHandler());
            }
        });
        bootstrap.setOption("sendBufferSize", 0x100000);
        bootstrap.setOption("receiveBufferSize", 0x100000);
        bootstrap.setOption("child.sctpNoDelay", true);
        bootstrap.bind(new InetSocketAddress(this.port));
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 2955;
        new SctpServer(port).run();
    }
}

