/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpMessage;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.List;

final class HttpCodecUtil {
    static final byte SP = 32;
    static final byte HT = 9;
    static final byte CR = 13;
    static final byte EQUALS = 61;
    static final byte LF = 10;
    static final byte[] CRLF = new byte[]{13, 10};
    static final byte COLON = 58;
    static final byte SEMICOLON = 59;
    static final byte COMMA = 44;
    static final byte DOUBLE_QUOTE = 34;
    static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;

    private HttpCodecUtil() {
    }

    static void validateHeaderName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException("name contains non-ascii character: " + name);
            }
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("name contains one of the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + name);
                }
            }
        }
    }

    static void validateHeaderValue(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        int state = 0;
        block19: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\u000b': {
                    throw new IllegalArgumentException("value contains a prohibited character '\\v': " + value);
                }
                case '\f': {
                    throw new IllegalArgumentException("value contains a prohibited character '\\f': " + value);
                }
            }
            switch (state) {
                case 0: {
                    switch (c) {
                        case '\r': {
                            state = 1;
                            break;
                        }
                        case '\n': {
                            state = 2;
                        }
                    }
                    continue block19;
                }
                case 1: {
                    switch (c) {
                        case '\n': {
                            state = 2;
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Only '\\n' is allowed after '\\r': " + value);
                }
                case 2: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            state = 0;
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Only ' ' and '\\t' are allowed after '\\n': " + value);
                }
            }
        }
        if (state != 0) {
            throw new IllegalArgumentException("value must not end with '\\r' or '\\n':" + value);
        }
    }

    static boolean isTransferEncodingChunked(HttpMessage m) {
        List<String> chunked = m.getHeaders("Transfer-Encoding");
        if (chunked.isEmpty()) {
            return false;
        }
        for (String v : chunked) {
            if (!v.equalsIgnoreCase("chunked")) continue;
            return true;
        }
        return false;
    }
}

