/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.oneone;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDownstreamHandler;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.Channels;
import io.netty.channel.MessageEvent;

public abstract class OneToOneEncoder
implements ChannelDownstreamHandler {
    protected OneToOneEncoder() {
    }

    @Override
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        Object encodedMessage;
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        MessageEvent e = (MessageEvent)evt;
        Object originalMessage = e.getMessage();
        if (originalMessage == (encodedMessage = this.encode(ctx, e.getChannel(), originalMessage))) {
            ctx.sendDownstream(evt);
        } else if (encodedMessage != null) {
            Channels.write(ctx, e.getFuture(), encodedMessage, e.getRemoteAddress());
        }
    }

    protected abstract Object encode(ChannelHandlerContext var1, Channel var2, Object var3) throws Exception;
}

