/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.HelixManager;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.rebalancer.util.ConstraintBasedAssignment;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.controller.stages.ResourceAssignment;
import org.apache.helix.controller.strategy.AutoRebalanceStrategy;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class AutoRebalancer
implements Rebalancer,
MappingCalculator {
    private HelixManager _manager;
    private AutoRebalanceStrategy _algorithm;
    private static final Logger LOG = Logger.getLogger(AutoRebalancer.class);

    @Override
    public void init(HelixManager manager) {
        this._manager = manager;
        this._algorithm = null;
    }

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ClusterDataCache clusterData) {
        ArrayList<String> partitions = new ArrayList<String>(currentIdealState.getPartitionSet());
        String stateModelName = currentIdealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = clusterData.getStateModelDef(stateModelName);
        Map<String, LiveInstance> liveInstance = clusterData.getLiveInstances();
        String replicas = currentIdealState.getReplicas();
        LinkedHashMap<String, Integer> stateCountMap = new LinkedHashMap();
        stateCountMap = AutoRebalancer.stateCount(stateModelDef, liveInstance.size(), Integer.parseInt(replicas));
        ArrayList<String> liveNodes = new ArrayList<String>(liveInstance.keySet());
        ArrayList<String> allNodes = new ArrayList<String>(clusterData.getInstanceConfigMap().keySet());
        Map<String, Map<String, String>> currentMapping = this.currentMapping(currentStateOutput, resourceName, partitions, stateCountMap);
        HashSet<String> taggedNodes = new HashSet<String>();
        HashSet<String> taggedLiveNodes = new HashSet<String>();
        if (currentIdealState.getInstanceGroupTag() != null) {
            for (String instanceName : allNodes) {
                if (!clusterData.getInstanceConfigMap().get(instanceName).containsTag(currentIdealState.getInstanceGroupTag())) continue;
                taggedNodes.add(instanceName);
                if (!liveInstance.containsKey(instanceName)) continue;
                taggedLiveNodes.add(instanceName);
            }
            if (!taggedLiveNodes.isEmpty()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("found the following participants with tag " + currentIdealState.getInstanceGroupTag() + " for " + resourceName + ": " + taggedLiveNodes));
                }
            } else if (taggedNodes.isEmpty()) {
                LOG.warn((Object)("Resource " + resourceName + " has tag " + currentIdealState.getInstanceGroupTag() + " but no configured participants have this tag"));
            } else {
                LOG.warn((Object)("Resource " + resourceName + " has tag " + currentIdealState.getInstanceGroupTag() + " but no live participants have this tag"));
            }
            allNodes = new ArrayList(taggedNodes);
            liveNodes = new ArrayList(taggedLiveNodes);
        }
        Collections.sort(allNodes);
        Collections.sort(liveNodes);
        int maxPartition = currentIdealState.getMaxPartitionsPerInstance();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("currentMapping: " + currentMapping));
            LOG.info((Object)("stateCountMap: " + stateCountMap));
            LOG.info((Object)("liveNodes: " + liveNodes));
            LOG.info((Object)("allNodes: " + allNodes));
            LOG.info((Object)("maxPartition: " + maxPartition));
        }
        AutoRebalanceStrategy.DefaultPlacementScheme placementScheme = new AutoRebalanceStrategy.DefaultPlacementScheme();
        placementScheme.init(this._manager);
        this._algorithm = new AutoRebalanceStrategy(resourceName, partitions, stateCountMap, maxPartition, placementScheme);
        ZNRecord newMapping = this._algorithm.computePartitionAssignment(liveNodes, currentMapping, allNodes);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("newMapping: " + newMapping));
        }
        IdealState newIdealState = new IdealState(resourceName);
        newIdealState.getRecord().setSimpleFields(currentIdealState.getRecord().getSimpleFields());
        newIdealState.setRebalanceMode(IdealState.RebalanceMode.FULL_AUTO);
        newIdealState.getRecord().setListFields(newMapping.getListFields());
        return newIdealState;
    }

    public static LinkedHashMap<String, Integer> stateCount(StateModelDefinition stateModelDef, int liveNodesNb, int totalReplicas) {
        String num;
        LinkedHashMap<String, Integer> stateCountMap = new LinkedHashMap<String, Integer>();
        List<String> statesPriorityList = stateModelDef.getStatesPriorityList();
        int replicas = totalReplicas;
        for (String state : statesPriorityList) {
            num = stateModelDef.getNumInstancesPerState(state);
            if ("N".equals(num)) {
                stateCountMap.put(state, liveNodesNb);
                continue;
            }
            if ("R".equals(num)) continue;
            int stateCount = -1;
            try {
                stateCount = Integer.parseInt(num);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (stateCount <= 0) continue;
            stateCountMap.put(state, stateCount);
            replicas -= stateCount;
        }
        for (String state : statesPriorityList) {
            num = stateModelDef.getNumInstancesPerState(state);
            if (!"R".equals(num)) continue;
            stateCountMap.put(state, replicas);
            break;
        }
        return stateCountMap;
    }

    private Map<String, Map<String, String>> currentMapping(CurrentStateOutput currentStateOutput, String resourceName, List<String> partitions, Map<String, Integer> stateCountMap) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (String partition : partitions) {
            Map<String, String> curStateMap = currentStateOutput.getCurrentStateMap(resourceName, new Partition(partition));
            map.put(partition, new HashMap());
            for (String node : curStateMap.keySet()) {
                String state = curStateMap.get(node);
                if (!stateCountMap.containsKey(state)) continue;
                ((Map)map.get(partition)).put(node, state);
            }
            Map<String, String> pendingStateMap = currentStateOutput.getPendingStateMap(resourceName, new Partition(partition));
            for (String node : pendingStateMap.keySet()) {
                String state = pendingStateMap.get(node);
                if (!stateCountMap.containsKey(state)) continue;
                ((Map)map.get(partition)).put(node, state);
            }
        }
        return map;
    }

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ClusterDataCache cache, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing resource:" + resource.getResourceName()));
        }
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        this.calculateAutoBalancedIdealState(cache, idealState, stateModelDef);
        ResourceAssignment partitionMapping = new ResourceAssignment();
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resource.getResourceName(), partition);
            Set<String> disabledInstancesForPartition = cache.getDisabledInstancesForPartition(partition.toString());
            List<String> preferenceList = ConstraintBasedAssignment.getPreferenceList(cache, partition, idealState, stateModelDef);
            Map<String, String> bestStateForPartition = ConstraintBasedAssignment.computeAutoBestStateForPartition(cache, stateModelDef, preferenceList, currentStateMap, disabledInstancesForPartition);
            partitionMapping.addReplicaMap(partition, bestStateForPartition);
        }
        return partitionMapping;
    }

    private void calculateAutoBalancedIdealState(ClusterDataCache cache, IdealState idealState, StateModelDefinition stateModelDef) {
        String topStateValue = stateModelDef.getStatesPriorityList().get(0);
        Set<String> liveInstances = cache.getLiveInstances().keySet();
        HashSet<String> taggedInstances = new HashSet<String>();
        if (idealState.getInstanceGroupTag() != null) {
            for (String instanceName : liveInstances) {
                if (!cache.getInstanceConfigMap().get(instanceName).containsTag(idealState.getInstanceGroupTag())) continue;
                taggedInstances.add(instanceName);
            }
        }
        if (taggedInstances.size() > 0) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("found the following instances with tag " + idealState.getResourceName() + " " + taggedInstances));
            }
            liveInstances = taggedInstances;
        }
        int replicas = 1;
        try {
            replicas = Integer.parseInt(idealState.getReplicas());
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
        TreeMap<String, List<String>> defaultListFields = new TreeMap<String, List<String>>();
        ArrayList emptyList = new ArrayList(0);
        for (String partition : idealState.getPartitionSet()) {
            defaultListFields.put(partition, emptyList);
        }
        idealState.getRecord().setListFields(defaultListFields);
        if (liveInstances.size() == 0) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No live instances, return. Idealstate : " + idealState.getResourceName()));
            }
            return;
        }
        HashMap<String, List<String>> masterAssignmentMap = new HashMap<String, List<String>>();
        for (String instanceName : liveInstances) {
            masterAssignmentMap.put(instanceName, new ArrayList());
        }
        HashSet<String> orphanedPartitions = new HashSet<String>();
        orphanedPartitions.addAll(idealState.getPartitionSet());
        for (String liveInstanceName : liveInstances) {
            CurrentState currentState = cache.getCurrentState(liveInstanceName, cache.getLiveInstances().get(liveInstanceName).getSessionId()).get(idealState.getId());
            if (currentState == null) continue;
            Map<String, String> partitionStates = currentState.getPartitionStateMap();
            for (String partitionName : partitionStates.keySet()) {
                String state = partitionStates.get(partitionName);
                if (!state.equals(topStateValue)) continue;
                ((List)masterAssignmentMap.get(liveInstanceName)).add(partitionName);
                orphanedPartitions.remove(partitionName);
            }
        }
        ArrayList<String> orphanedPartitionsList = new ArrayList<String>();
        orphanedPartitionsList.addAll(orphanedPartitions);
        int maxPartitionsPerInstance = idealState.getMaxPartitionsPerInstance();
        this.normalizeAssignmentMap(masterAssignmentMap, orphanedPartitionsList, maxPartitionsPerInstance);
        idealState.getRecord().setListFields(this.generateListFieldFromMasterAssignment(masterAssignmentMap, replicas));
    }

    private void normalizeAssignmentMap(Map<String, List<String>> masterAssignmentMap, List<String> orphanPartitions, int maxPartitionsPerInstance) {
        int lastElementIndex;
        int targetPartitionNo;
        int i;
        int totalPartitions = 0;
        Object[] instanceNames = new String[masterAssignmentMap.size()];
        masterAssignmentMap.keySet().toArray(instanceNames);
        Arrays.sort(instanceNames);
        for (String key : masterAssignmentMap.keySet()) {
            totalPartitions += masterAssignmentMap.get(key).size();
            Collections.sort(masterAssignmentMap.get(key));
        }
        int partitionNumber = (totalPartitions += orphanPartitions.size()) / masterAssignmentMap.size();
        int leave = totalPartitions % masterAssignmentMap.size();
        for (i = 0; i < instanceNames.length; ++i) {
            targetPartitionNo = leave > 0 ? partitionNumber + 1 : partitionNumber;
            --leave;
            while (masterAssignmentMap.get(instanceNames[i]).size() > targetPartitionNo) {
                lastElementIndex = masterAssignmentMap.get(instanceNames[i]).size() - 1;
                orphanPartitions.add(masterAssignmentMap.get(instanceNames[i]).get(lastElementIndex));
                masterAssignmentMap.get(instanceNames[i]).remove(lastElementIndex);
            }
        }
        leave = totalPartitions % masterAssignmentMap.size();
        Collections.sort(orphanPartitions);
        for (i = 0; i < instanceNames.length; ++i) {
            targetPartitionNo = leave > 0 ? partitionNumber + 1 : partitionNumber;
            --leave;
            if (targetPartitionNo > maxPartitionsPerInstance) {
                targetPartitionNo = maxPartitionsPerInstance;
            }
            while (masterAssignmentMap.get(instanceNames[i]).size() < targetPartitionNo) {
                lastElementIndex = orphanPartitions.size() - 1;
                masterAssignmentMap.get(instanceNames[i]).add(orphanPartitions.get(lastElementIndex));
                orphanPartitions.remove(lastElementIndex);
            }
        }
        if (orphanPartitions.size() > 0) {
            LOG.warn((Object)"orphanPartitions still contains elements");
        }
    }

    private Map<String, List<String>> generateListFieldFromMasterAssignment(Map<String, List<String>> masterAssignmentMap, int replicas) {
        HashMap<String, List<String>> listFields = new HashMap<String, List<String>>();
        int slaves = replicas - 1;
        Object[] instanceNames = new String[masterAssignmentMap.size()];
        masterAssignmentMap.keySet().toArray(instanceNames);
        Arrays.sort(instanceNames);
        for (int i = 0; i < instanceNames.length; ++i) {
            Object instanceName = instanceNames[i];
            ArrayList<Object> otherInstances = new ArrayList<Object>(masterAssignmentMap.size() - 1);
            for (int x = 0; x < instanceNames.length - 1; ++x) {
                int index = (x + i + 1) % instanceNames.length;
                otherInstances.add(instanceNames[index]);
            }
            List<String> partitionList = masterAssignmentMap.get(instanceName);
            for (int j = 0; j < partitionList.size(); ++j) {
                String partitionName = partitionList.get(j);
                listFields.put(partitionName, new ArrayList());
                ((List)listFields.get(partitionName)).add(instanceName);
                int slavesCanAssign = Math.min(slaves, otherInstances.size());
                for (int k = 0; k < slavesCanAssign; ++k) {
                    int index = (j + k + 1) % otherInstances.size();
                    ((List)listFields.get(partitionName)).add(otherInstances.get(index));
                }
            }
        }
        return listFields;
    }
}

