/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.util.Iterator;
import java.util.List;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Status;
import org.restlet.engine.local.Entity;
import org.restlet.engine.local.LocalClientHelper;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;

public abstract class EntityClientHelper
extends LocalClientHelper {
    public EntityClientHelper(Client client) {
        super(client);
    }

    public Reference createReference(String scheme, String encodedParentDirPath, String encodedEntityName, String decodedVariantName) {
        Reference result = new Reference(scheme + "://" + encodedParentDirPath + "/" + this.getReencodedVariantEntityName(encodedEntityName, decodedVariantName));
        return result;
    }

    public abstract Entity getEntity(String var1);

    protected String getReencodedVariantEntityName(String encodedEntityName, String decodedVariantEntityName) {
        int i = 0;
        int j = 0;
        boolean stop = false;
        char[] encodeds = encodedEntityName.toCharArray();
        char[] decodeds = decodedVariantEntityName.toCharArray();
        for (i = 0; i < decodeds.length && j < encodeds.length && !stop; ++i) {
            String dec;
            char decodedChar = decodeds[i];
            char encodedChar = encodeds[j];
            if (encodedChar == '%') {
                dec = Reference.decode(encodedEntityName.substring(j, j + 3));
                if (decodedChar == dec.charAt(0)) {
                    j += 3;
                    continue;
                }
                stop = true;
                continue;
            }
            if (decodedChar == encodedChar) {
                ++j;
                continue;
            }
            dec = Reference.decode(encodedEntityName.substring(j, j + 1));
            if (decodedChar == dec.charAt(0)) {
                ++j;
                continue;
            }
            stop = true;
        }
        if (stop) {
            return encodedEntityName.substring(0, j) + decodedVariantEntityName.substring(i - 1);
        }
        if (j == encodedEntityName.length()) {
            return encodedEntityName.substring(0, j) + decodedVariantEntityName.substring(i);
        }
        return encodedEntityName.substring(0, j);
    }

    protected void handleEntityGet(Request request, Response response, Entity entity) {
        Representation output = null;
        boolean found = false;
        Iterator<Preference<MediaType>> iterator = request.getClientInfo().getAcceptedMediaTypes().iterator();
        while (iterator.hasNext() && !found) {
            Preference<MediaType> pref = iterator.next();
            found = pref.getMetadata().equals(MediaType.TEXT_URI_LIST);
        }
        if (found) {
            List<Entity> entities;
            String baseName = entity.getBaseName();
            Entity parent = entity.getParent();
            if (parent != null && (entities = parent.getChildren()) != null) {
                ReferenceList rl = new ReferenceList(entities.size());
                String scheme = request.getResourceRef().getScheme();
                String path = request.getResourceRef().getPath();
                String encodedParentDirectoryURI = path.substring(0, path.lastIndexOf("/"));
                String encodedEntityName = path.substring(path.lastIndexOf("/") + 1);
                for (Entity entry : entities) {
                    if (!baseName.equals(entry.getBaseName())) continue;
                    rl.add(this.createReference(scheme, encodedParentDirectoryURI, encodedEntityName, entry.getName()));
                }
                output = rl.getTextRepresentation();
            }
        } else if (entity.exists()) {
            if (entity.isDirectory()) {
                List<Entity> children = entity.getChildren();
                ReferenceList rl = new ReferenceList(children.size());
                String directoryUri = request.getResourceRef().getTargetRef().toString();
                if (!directoryUri.endsWith("/")) {
                    directoryUri = directoryUri + "/";
                }
                for (Entity entry : children) {
                    if (entry.isDirectory()) {
                        rl.add(directoryUri + Reference.encode(entry.getName()) + "/");
                        continue;
                    }
                    rl.add(directoryUri + Reference.encode(entry.getName()));
                }
                output = rl.getTextRepresentation();
            } else {
                output = entity.getRepresentation(this.getMetadataService().getDefaultMediaType(), this.getTimeToLive());
                output.setLocationRef(request.getResourceRef());
                Entity.updateMetadata(entity.getName(), output, true, this.getMetadataService());
            }
        } else {
            List<Entity> files;
            Entity uniqueVariant = null;
            String baseName = entity.getBaseName();
            Variant entityVariant = entity.getVariant();
            Entity parent = entity.getParent();
            if (parent != null && (files = parent.getChildren()) != null) {
                for (Entity entry : files) {
                    Variant entryVariant;
                    if (!baseName.equals(entry.getBaseName()) || !entityVariant.isCompatible(entryVariant = entry.getVariant())) continue;
                    uniqueVariant = entry;
                    break;
                }
            }
            if (uniqueVariant != null) {
                output = uniqueVariant.getRepresentation(this.getMetadataService().getDefaultMediaType(), this.getTimeToLive());
                output.setLocationRef(request.getResourceRef());
                Entity.updateMetadata(entity.getName(), output, true, this.getMetadataService());
            }
        }
        if (output == null) {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        } else {
            output.setLocationRef(request.getResourceRef());
            response.setEntity(output);
            response.setStatus(Status.SUCCESS_OK);
        }
    }

    protected void handleLocal(Request request, Response response, String decodedPath) {
        if (Method.GET.equals(request.getMethod()) || Method.HEAD.equals(request.getMethod())) {
            this.handleEntityGet(request, response, this.getEntity(decodedPath));
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.getAllowedMethods().add(Method.GET);
            response.getAllowedMethods().add(Method.HEAD);
        }
    }
}

