/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.channel.Channel;
import io.netty.channel.local.LocalAddress;
import io.netty.util.internal.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class LocalChannelRegistry {
    private static final ConcurrentMap<LocalAddress, Channel> map = new ConcurrentHashMap<LocalAddress, Channel>();

    static boolean isRegistered(LocalAddress address) {
        return map.containsKey(address);
    }

    static Channel getChannel(LocalAddress address) {
        return (Channel)map.get(address);
    }

    static boolean register(LocalAddress address, Channel channel) {
        return map.putIfAbsent(address, channel) == null;
    }

    static boolean unregister(LocalAddress address) {
        return map.remove(address) != null;
    }

    private LocalChannelRegistry() {
    }
}

