/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelSink;
import io.netty.channel.socket.DefaultSocketChannelConfig;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.socket.oio.AbstractOioChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

abstract class OioSocketChannel
extends AbstractOioChannel
implements SocketChannel {
    final Socket socket;
    private final SocketChannelConfig config;

    OioSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, Socket socket) {
        super(parent, factory, pipeline, sink);
        this.socket = socket;
        this.config = new DefaultSocketChannelConfig(socket);
    }

    @Override
    public SocketChannelConfig getConfig() {
        return this.config;
    }

    abstract PushbackInputStream getInputStream();

    abstract OutputStream getOutputStream();

    @Override
    boolean isSocketBound() {
        return this.socket.isBound();
    }

    @Override
    boolean isSocketConnected() {
        return this.socket.isConnected();
    }

    @Override
    InetSocketAddress getLocalSocketAddress() throws Exception {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    @Override
    InetSocketAddress getRemoteSocketAddress() throws Exception {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    @Override
    void closeSocket() throws IOException {
        this.socket.close();
    }

    @Override
    boolean isSocketClosed() {
        return this.socket.isClosed();
    }
}

