/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.snoop;

import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineFactory;
import io.netty.channel.Channels;
import io.netty.example.http.snoop.HttpSnoopClientHandler;
import io.netty.example.securechat.SecureChatSslContextFactory;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.logging.InternalLogLevel;
import javax.net.ssl.SSLEngine;

public class HttpSnoopClientPipelineFactory
implements ChannelPipelineFactory {
    private final boolean ssl;

    public HttpSnoopClientPipelineFactory(boolean ssl) {
        this.ssl = ssl;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("log", new LoggingHandler(InternalLogLevel.INFO));
        if (this.ssl) {
            SSLEngine engine = SecureChatSslContextFactory.getClientContext().createSSLEngine();
            engine.setUseClientMode(true);
            pipeline.addLast("ssl", new SslHandler(engine));
        }
        pipeline.addLast("codec", new HttpClientCodec());
        pipeline.addLast("inflater", new HttpContentDecompressor());
        pipeline.addLast("handler", new HttpSnoopClientHandler());
        return pipeline;
    }
}

