/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.sslserver;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.socket.nio.NioServerSocketChannelFactory;
import io.netty.example.http.websocketx.sslserver.WebSocketSslServerPipelineFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class WebSocketSslServer {
    private final int port;

    public WebSocketSslServer(int port) {
        this.port = port;
    }

    public void run() {
        ServerBootstrap bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new WebSocketSslServerPipelineFactory());
        bootstrap.bind(new InetSocketAddress(this.port));
        System.out.println("Web socket server started at port " + this.port + '.');
        System.out.println("Open your browser and navigate to https://localhost:" + this.port + '/');
    }

    public static void main(String[] args) {
        String keyStoreFilePassword;
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8443;
        String keyStoreFilePath = System.getProperty("keystore.file.path");
        if (keyStoreFilePath == null || keyStoreFilePath.isEmpty()) {
            System.out.println("ERROR: System property keystore.file.path not set. Exiting now!");
            System.exit(1);
        }
        if ((keyStoreFilePassword = System.getProperty("keystore.file.password")) == null || keyStoreFilePassword.isEmpty()) {
            System.out.println("ERROR: System property keystore.file.password not set. Exiting now!");
            System.exit(1);
        }
        new WebSocketSslServer(port).run();
    }
}

