/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.portunification;

import io.netty.buffer.ChannelBuffer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.example.factorial.BigIntegerDecoder;
import io.netty.example.factorial.FactorialServerHandler;
import io.netty.example.factorial.NumberEncoder;
import io.netty.example.http.snoop.HttpSnoopServerHandler;
import io.netty.example.securechat.SecureChatSslContextFactory;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.frame.FrameDecoder;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;

public class PortUnificationServerHandler
extends FrameDecoder {
    private final boolean detectSsl;
    private final boolean detectGzip;

    public PortUnificationServerHandler() {
        this(true, true);
    }

    private PortUnificationServerHandler(boolean detectSsl, boolean detectGzip) {
        this.detectSsl = detectSsl;
        this.detectGzip = detectGzip;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 2) {
            return null;
        }
        short magic1 = buffer.getUnsignedByte(buffer.readerIndex());
        short magic2 = buffer.getUnsignedByte(buffer.readerIndex() + 1);
        if (this.isSsl(magic1)) {
            this.enableSsl(ctx);
        } else if (this.isGzip(magic1, magic2)) {
            this.enableGzip(ctx);
        } else if (this.isHttp(magic1, magic2)) {
            this.switchToHttp(ctx);
        } else if (this.isFactorial(magic1)) {
            this.switchToFactorial(ctx);
        } else {
            buffer.skipBytes(buffer.readableBytes());
            ctx.getChannel().close();
            return null;
        }
        return buffer.readBytes(buffer.readableBytes());
    }

    private boolean isSsl(int magic1) {
        if (this.detectSsl) {
            switch (magic1) {
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 255: {
                    return true;
                }
            }
            return magic1 >= 128;
        }
        return false;
    }

    private boolean isGzip(int magic1, int magic2) {
        if (this.detectGzip) {
            return magic1 == 31 && magic2 == 139;
        }
        return false;
    }

    private boolean isHttp(int magic1, int magic2) {
        return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82 || magic1 == 67 && magic2 == 79;
    }

    private boolean isFactorial(int magic1) {
        return magic1 == 70;
    }

    private void enableSsl(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.getPipeline();
        SSLEngine engine = SecureChatSslContextFactory.getServerContext().createSSLEngine();
        engine.setUseClientMode(false);
        p.addLast("ssl", new SslHandler(engine));
        p.addLast("unificationA", new PortUnificationServerHandler(false, this.detectGzip));
        p.remove(this);
    }

    private void enableGzip(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.getPipeline();
        p.addLast("gzipdeflater", new ZlibEncoder(ZlibWrapper.GZIP));
        p.addLast("gzipinflater", new ZlibDecoder(ZlibWrapper.GZIP));
        p.addLast("unificationB", new PortUnificationServerHandler(this.detectSsl, false));
        p.remove(this);
    }

    private void switchToHttp(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.getPipeline();
        p.addLast("decoder", new HttpRequestDecoder());
        p.addLast("encoder", new HttpResponseEncoder());
        p.addLast("deflater", new HttpContentCompressor());
        p.addLast("handler", new HttpSnoopServerHandler());
        p.remove(this);
    }

    private void switchToFactorial(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.getPipeline();
        p.addLast("decoder", new BigIntegerDecoder());
        p.addLast("encoder", new NumberEncoder());
        p.addLast("handler", new FactorialServerHandler());
        p.remove(this);
    }
}

