/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.Channels;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelUpstreamHandler;
import io.netty.handler.codec.embedder.DecoderEmbedder;
import io.netty.handler.codec.http.DefaultHttpChunk;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;

public abstract class HttpContentDecoder
extends SimpleChannelUpstreamHandler {
    private DecoderEmbedder<ChannelBuffer> decoder;

    protected HttpContentDecoder() {
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof HttpResponse && ((HttpResponse)msg).getStatus().getCode() == 100) {
            ctx.sendUpstream(e);
        } else if (msg instanceof HttpMessage) {
            boolean hasContent;
            HttpMessage m = (HttpMessage)msg;
            this.decoder = null;
            String contentEncoding = m.getHeader("Content-Encoding");
            contentEncoding = contentEncoding != null ? contentEncoding.trim() : "identity";
            boolean bl = hasContent = m.isChunked() || m.getContent().readable();
            if (hasContent && (this.decoder = this.newContentDecoder(contentEncoding)) != null) {
                m.setHeader("Content-Encoding", this.getTargetContentEncoding(contentEncoding));
                if (!m.isChunked()) {
                    ChannelBuffer content = m.getContent();
                    content = ChannelBuffers.wrappedBuffer(this.decode(content), this.finishDecode());
                    m.setContent(content);
                    if (m.containsHeader("Content-Length")) {
                        m.setHeader("Content-Length", Integer.toString(content.readableBytes()));
                    }
                }
            }
            ctx.sendUpstream(e);
        } else if (msg instanceof HttpChunk) {
            HttpChunk c = (HttpChunk)msg;
            ChannelBuffer content = c.getContent();
            if (this.decoder != null) {
                if (!c.isLast()) {
                    if ((content = this.decode(content)).readable()) {
                        c.setContent(content);
                        ctx.sendUpstream(e);
                    }
                } else {
                    ChannelBuffer lastProduct = this.finishDecode();
                    if (lastProduct.readable()) {
                        Channels.fireMessageReceived(ctx, (Object)new DefaultHttpChunk(lastProduct), e.getRemoteAddress());
                    }
                    ctx.sendUpstream(e);
                }
            } else {
                ctx.sendUpstream(e);
            }
        } else {
            ctx.sendUpstream(e);
        }
    }

    protected abstract DecoderEmbedder<ChannelBuffer> newContentDecoder(String var1) throws Exception;

    protected String getTargetContentEncoding(String contentEncoding) throws Exception {
        return "identity";
    }

    private ChannelBuffer decode(ChannelBuffer buf) {
        this.decoder.offer(buf);
        return ChannelBuffers.wrappedBuffer(this.decoder.pollAll(new ChannelBuffer[this.decoder.size()]));
    }

    private ChannelBuffer finishDecode() {
        ChannelBuffer result = this.decoder.finish() ? ChannelBuffers.wrappedBuffer(this.decoder.pollAll(new ChannelBuffer[this.decoder.size()])) : ChannelBuffers.EMPTY_BUFFER;
        this.decoder = null;
        return result;
    }
}

