/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.util.ArrayList;
import java.util.List;
import org.restlet.Request;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.engine.application.StrictConneg;
import org.restlet.service.MetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexibleConneg
extends StrictConneg {
    private volatile List<Preference<CharacterSet>> characterSetPrefs;
    private volatile List<Preference<Encoding>> encodingPrefs;
    private volatile List<Preference<Language>> languagePrefs;
    private volatile List<Preference<MediaType>> mediaTypePrefs;

    public FlexibleConneg(Request request, MetadataService metadataService) {
        super(request, metadataService);
        ClientInfo clientInfo = request.getClientInfo();
        if (clientInfo != null) {
            this.languagePrefs = this.getEnrichedPreferences(clientInfo.getAcceptedLanguages(), metadataService == null ? null : metadataService.getDefaultLanguage(), Language.ALL);
            this.mediaTypePrefs = this.getEnrichedPreferences(clientInfo.getAcceptedMediaTypes(), metadataService == null ? null : metadataService.getDefaultMediaType(), MediaType.ALL);
            this.characterSetPrefs = this.getEnrichedPreferences(clientInfo.getAcceptedCharacterSets(), metadataService == null ? null : metadataService.getDefaultCharacterSet(), CharacterSet.ALL);
            this.encodingPrefs = this.getEnrichedPreferences(clientInfo.getAcceptedEncodings(), metadataService == null ? null : metadataService.getDefaultEncoding(), Encoding.ALL);
        }
    }

    protected <T extends Metadata> boolean canAdd(T metadata, List<T> undesired) {
        boolean add = true;
        if (undesired != null) {
            for (Metadata u : undesired) {
                if (!u.equals(metadata)) continue;
                add = false;
                break;
            }
        }
        return add;
    }

    @Override
    protected List<Preference<CharacterSet>> getCharacterSetPrefs() {
        return this.characterSetPrefs;
    }

    @Override
    protected List<Preference<Encoding>> getEncodingPrefs() {
        return this.encodingPrefs;
    }

    protected <T extends Metadata> List<Preference<T>> getEnrichedPreferences(List<Preference<T>> userPreferences, T defaultValue, T allValue) {
        ArrayList<Preference<T>> result = new ArrayList<Preference<T>>();
        ArrayList<T> undesired = null;
        for (Preference<T> pref : userPreferences) {
            if (pref.getQuality() != 0.0f) continue;
            if (undesired == null) {
                undesired = new ArrayList<T>();
            }
            undesired.add(pref.getMetadata());
        }
        result.addAll(userPreferences);
        for (int i = 0; i < result.size(); ++i) {
            Preference userPref = (Preference)result.get(i);
            Metadata parent = ((Metadata)userPref.getMetadata()).getParent();
            if (parent == null || !this.canAdd(parent, undesired)) continue;
            result.add(new Preference<Metadata>(parent, 0.005f + 0.001f * userPref.getQuality()));
        }
        if (defaultValue != null && this.canAdd(defaultValue, undesired)) {
            Preference<T> defaultPref = new Preference<T>(defaultValue, 0.003f);
            result.add(defaultPref);
            Metadata defaultParent = defaultValue.getParent();
            if (defaultParent != null && this.canAdd(defaultParent, undesired)) {
                result.add(new Preference<Metadata>(defaultParent, 0.002f));
            }
        }
        for (int i = result.size() - 1; i >= 0; --i) {
            if (!((Metadata)((Preference)result.get(i)).getMetadata()).equals(allValue)) continue;
            result.remove(i);
        }
        result.add(new Preference<T>(allValue, 0.001f));
        return result;
    }

    @Override
    protected List<Preference<Language>> getLanguagePrefs() {
        return this.languagePrefs;
    }

    @Override
    protected List<Preference<MediaType>> getMediaTypePrefs() {
        return this.mediaTypePrefs;
    }
}

