/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import java.util.UUID;
import org.apache.helix.ClusterMessagingService;
import org.apache.helix.Criteria;
import org.apache.helix.HelixManager;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.examples.BootstrapReplyHandler;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.participant.statemachine.Transition;

public class BootstrapHandler
extends StateModelFactory<StateModel> {
    @Override
    public StateModel createNewStateModel(String stateUnitKey) {
        return new BootstrapStateModel(stateUnitKey);
    }

    @StateModelInfo(initialState="OFFLINE", states={"{'OFFLINE','SLAVE','MASTER'}"})
    public static class BootstrapStateModel
    extends StateModel {
        private final String _stateUnitKey;

        public BootstrapStateModel(String stateUnitKey) {
            this._stateUnitKey = stateUnitKey;
        }

        @Transition(from="MASTER", to="SLAVE")
        public void masterToSlave(Message message, NotificationContext context) {
        }

        @Transition(from="OFFLINE", to="SLAVE")
        public void offlineToSlave(Message message, NotificationContext context) {
            System.out.println("BootstrapProcess.BootstrapStateModel.offlineToSlave()");
            HelixManager manager = context.getManager();
            ClusterMessagingService messagingService = manager.getMessagingService();
            Message requestBackupUriRequest = new Message(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
            requestBackupUriRequest.setMsgSubType("REQUEST_BOOTSTRAP_URL");
            requestBackupUriRequest.setMsgState(Message.MessageState.NEW);
            Criteria recipientCriteria = new Criteria();
            recipientCriteria.setInstanceName("*");
            recipientCriteria.setRecipientInstanceType(InstanceType.PARTICIPANT);
            recipientCriteria.setResource(message.getResourceName());
            recipientCriteria.setPartition(message.getPartitionName());
            recipientCriteria.setSessionSpecific(true);
            int timeout = 30000;
            BootstrapReplyHandler responseHandler = new BootstrapReplyHandler();
            int sentMessageCount = messagingService.sendAndWait(recipientCriteria, requestBackupUriRequest, responseHandler, timeout);
            if (sentMessageCount != 0 && responseHandler.getBootstrapUrl() != null) {
                System.out.println("Got bootstrap url:" + responseHandler.getBootstrapUrl());
                System.out.println("Got backup time:" + responseHandler.getBootstrapTime());
            }
        }

        @Transition(from="SLAVE", to="OFFLINE")
        public void slaveToOffline(Message message, NotificationContext context) {
            System.out.println("BootstrapProcess.BootstrapStateModel.slaveToOffline()");
        }

        @Transition(from="SLAVE", to="MASTER")
        public void slaveToMaster(Message message, NotificationContext context) {
            System.out.println("BootstrapProcess.BootstrapStateModel.slaveToMaster()");
        }
    }
}

