/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl;

import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.UriRef;

public class TripleImpl
implements Triple {
    private final NonLiteral subject;
    private final UriRef predicate;
    private final Resource object;

    public TripleImpl(NonLiteral subject, UriRef predicate, Resource object) {
        if (subject == null) {
            throw new IllegalArgumentException("Invalid subject: null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Invalid predicate: null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Invalid object: null");
        }
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Triple)) {
            return false;
        }
        Triple other = (Triple)obj;
        if (!this.subject.equals(other.getSubject())) {
            return false;
        }
        if (!this.predicate.equals(other.getPredicate())) {
            return false;
        }
        return this.object.equals(other.getObject());
    }

    @Override
    public int hashCode() {
        return this.subject.hashCode() >> 1 ^ this.subject.hashCode() ^ this.subject.hashCode() << 1;
    }

    @Override
    public NonLiteral getSubject() {
        return this.subject;
    }

    @Override
    public UriRef getPredicate() {
        return this.predicate;
    }

    @Override
    public Resource getObject() {
        return this.object;
    }

    public String toString() {
        return this.subject + " " + this.predicate + " " + this.object + ".";
    }
}

