/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.spi.config;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.util.BeanUtils;

public abstract class BaseConfigPropertyProducer {
    protected String getStringPropertyValue(InjectionPoint injectionPoint) {
        ConfigProperty configProperty = this.getAnnotation(injectionPoint, ConfigProperty.class);
        if (configProperty == null) {
            throw new IllegalStateException("producer method called without @ConfigProperty being present!");
        }
        String defaultValue = configProperty.defaultValue();
        String configuredValue = this.getPropertyValue(configProperty.name(), defaultValue);
        return configuredValue;
    }

    protected String getPropertyValue(String propertyName, String defaultValue) {
        String configuredValue = "org.apache.deltaspike.NullValueMarker".equals(defaultValue) ? ConfigResolver.getPropertyValue(propertyName) : ConfigResolver.getPropertyValue(propertyName, defaultValue);
        return configuredValue;
    }

    protected <T extends Annotation> T getAnnotation(InjectionPoint injectionPoint, Class<T> targetType) {
        return BeanUtils.extractAnnotation(injectionPoint.getAnnotated(), targetType);
    }
}

