/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "ksh" locale.
 */
public class LocalizedNamesImpl_ksh extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AR",
        "EG",
        "EC",
        "AL",
        "CI",
        "DZ",
        "SV",
        "AS",
        "AD",
        "AI",
        "AO",
        "AG",
        "GQ",
        "ER",
        "AM",
        "AW",
        "AC",
        "AZ",
        "EE",
        "ET",
        "AU",
        "BH",
        "BD",
        "BZ",
        "BE",
        "MM",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "IO",
        "BN",
        "BF",
        "BG",
        "BI",
        "BT",
        "BV",
        "CW",
        "BJ",
        "CG",
        "CD",
        "DK",
        "VI",
        "BS",
        "BM",
        "VG",
        "DG",
        "DO",
        "BB",
        "SJ",
        "TC",
        "IM",
        "LC",
        "EU",
        "FK",
        "FO",
        "FJ",
        "PH",
        "HM",
        "KY",
        "IC",
        "CV",
        "CP",
        "CC",
        "KM",
        "CK",
        "MH",
        "MV",
        "MN",
        "NL",
        "AN",
        "MP",
        "NF",
        "AX",
        "PN",
        "IQ",
        "YE",
        "LB",
        "OM",
        "SN",
        "AQ",
        "SD",
        "TD",
        "VA",
        "CH",
        "SC",
        "SH",
        "MF",
        "SB",
        "TR",
        "CZ",
        "UA",
        "UM",
        "US",
        "CX",
        "CF",
        "BL",
        "SK",
        "DM",
        "DE",
        "DJ",
        "ME",
        "FI",
        "FR",
        "TF",
        "GF",
        "PF",
        "HT",
        "HN",
        "HK",
        "IN",
        "ID",
        "IE",
        "IS",
        "IL",
        "IT",
        "GH",
        "GA",
        "GM",
        "JM",
        "JP",
        "GE",
        "GI",
        "GN",
        "GW",
        "GG",
        "JE",
        "JO",
        "GD",
        "GR",
        "GL",
        "GB",
        "GP",
        "GU",
        "GY",
        "GT",
        "KH",
        "CM",
        "CA",
        "KZ",
        "QA",
        "KE",
        "KI",
        "KG",
        "CO",
        "CR",
        "HR",
        "CU",
        "KW",
        "LA",
        "LV",
        "LS",
        "LY",
        "LR",
        "LI",
        "LT",
        "LU",
        "ML",
        "MQ",
        "MG",
        "YT",
        "MO",
        "MY",
        "MW",
        "MT",
        "MA",
        "MU",
        "MR",
        "MK",
        "MX",
        "FM",
        "MD",
        "MC",
        "MS",
        "MZ",
        "NA",
        "NR",
        "NP",
        "NC",
        "NZ",
        "NE",
        "NG",
        "NI",
        "NU",
        "KP",
        "NO",
        "AT",
        "TL",
        "QO",
        "PK",
        "PS",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "IR",
        "PT",
        "PR",
        "PL",
        "RE",
        "RO",
        "RW",
        "RU",
        "ZM",
        "WS",
        "SM",
        "RS",
        "SA",
        "CL",
        "CN",
        "ES",
        "SE",
        "ZW",
        "SG",
        "SL",
        "ZA",
        "GS",
        "KR",
        "SO",
        "LK",
        "SS",
        "SI",
        "SZ",
        "SY",
        "SR",
        "SX",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TK",
        "TO",
        "TG",
        "TT",
        "TA",
        "TN",
        "TM",
        "TV",
        "UG",
        "HU",
        "UY",
        "UZ",
        "VU",
        "VE",
        "AE",
        "VN",
        "WF",
        "EH",
        "BY",
        "EA",
        "KN",
        "PM",
        "ST",
        "VC",
        "CY",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "de Ääd");
    namesMap.put("002", "Affrika");
    namesMap.put("003", "Nood-Amärrika");
    namesMap.put("005", "Söd-Amärrika");
    namesMap.put("009", "Ozejaanije");
    namesMap.put("011", "Wäß-Affrika");
    namesMap.put("013", "Meddelammärrika");
    namesMap.put("014", "Oß-Affrika");
    namesMap.put("015", "Nood-Affrika");
    namesMap.put("017", "Meddel-Affrika");
    namesMap.put("018", "Söd-Affrika");
    namesMap.put("019", "Ammärrika");
    namesMap.put("021", "der Norde vun Amärrika");
    namesMap.put("029", "de Karribik");
    namesMap.put("030", "Oß-Aasije");
    namesMap.put("034", "Söd-Aasije");
    namesMap.put("035", "Söd-Oß-Aasije");
    namesMap.put("039", "Söd-Europpa");
    namesMap.put("053", "de Rejjohn Austraalije");
    namesMap.put("054", "Mellaneesije");
    namesMap.put("057", "de Rejohn vun Mikroneeseje");
    namesMap.put("061", "Polineesije");
    namesMap.put("142", "Aasije");
    namesMap.put("143", "Meddelaasije");
    namesMap.put("145", "Wäß-Aasije");
    namesMap.put("150", "Europpa");
    namesMap.put("151", "Oß-Europpa");
    namesMap.put("154", "Nood-Europpa");
    namesMap.put("155", "Wäß-Europpa");
    namesMap.put("419", "Lateinamärrika");
    namesMap.put("AC", "Aßension");
    namesMap.put("AE", "Vereinschte Arrabesche Emmirate");
    namesMap.put("AF", "Afjaanistahn");
    namesMap.put("AG", "Antigwa un Barbuda");
    namesMap.put("AI", "Anggwilla");
    namesMap.put("AL", "Albaanije");
    namesMap.put("AM", "Arrmeenije");
    namesMap.put("AN", "de Nederlängsche Antille");
    namesMap.put("AO", "Angjoola");
    namesMap.put("AQ", "der Södpol");
    namesMap.put("AR", "Ajjentiinije");
    namesMap.put("AS", "Ammerikaanesch Sammoha");
    namesMap.put("AT", "Öösterisch");
    namesMap.put("AU", "Austraalije");
    namesMap.put("AX", "de Ohland-Enselle");
    namesMap.put("AZ", "Asserbaidschahn");
    namesMap.put("BA", "Boßnije");
    namesMap.put("BB", "de Ensel Barbados");
    namesMap.put("BD", "Bangladesch");
    namesMap.put("BE", "Bellje");
    namesMap.put("BF", "Bukkinna-Faase");
    namesMap.put("BG", "Bulljaarije");
    namesMap.put("BH", "Bachrain");
    namesMap.put("BJ", "dä Benin");
    namesMap.put("BL", "de Zint Battälmi-Enselle");
    namesMap.put("BM", "de Bermudas");
    namesMap.put("BO", "Bolliivije");
    namesMap.put("BR", "Brasilije");
    namesMap.put("BS", "de Bahamas");
    namesMap.put("BT", "Buttaan");
    namesMap.put("BV", "Buvee-Ensel");
    namesMap.put("BW", "Bozwaana");
    namesMap.put("BY", "Wießrußland");
    namesMap.put("CA", "Kannada");
    namesMap.put("CC", "de Kokkos-Enselle");
    namesMap.put("CD", "dä Konggo (Kinschasa)");
    namesMap.put("CF", "de Zäntraalaffrikaanesche Republik");
    namesMap.put("CG", "dä Konggo (Brassavill)");
    namesMap.put("CH", "de Schweiz");
    namesMap.put("CI", "Älfebeijn-Köß");
    namesMap.put("CK", "de Kuuk-Enselle");
    namesMap.put("CL", "Schiile");
    namesMap.put("CM", "Kammeruhn");
    namesMap.put("CN", "Schiina");
    namesMap.put("CO", "Kolumbije");
    namesMap.put("CP", "de Klipperton-Ensel");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "de Kapvärdesche Enselle");
    namesMap.put("CX", "de Weihnaachs-Ensel");
    namesMap.put("CY", "Züppere");
    namesMap.put("CZ", "de Tschäschei");
    namesMap.put("DE", "Doütschland");
    namesMap.put("DG", "de Diego-Garcia-Ensel");
    namesMap.put("DJ", "Dschibutti");
    namesMap.put("DK", "Dänemark");
    namesMap.put("DM", "Dominnika");
    namesMap.put("DO", "de Dommenekaanesche Reppublik");
    namesMap.put("DZ", "Alljeerije");
    namesMap.put("EA", "Ze'uta un Meliija");
    namesMap.put("EC", "Äkwador");
    namesMap.put("EE", "Äßland");
    namesMap.put("EG", "Äjüpte");
    namesMap.put("EH", "Wäß-Sahara");
    namesMap.put("ER", "Äritreja");
    namesMap.put("ES", "Schpaanije");
    namesMap.put("ET", "Ättijoopije");
    namesMap.put("EU", "de Eurppäesche Unijon");
    namesMap.put("FI", "Finnland");
    namesMap.put("FJ", "de Fidschi-Endelle");
    namesMap.put("FK", "de Falkland-Enselle");
    namesMap.put("FM", "Mikroneesije");
    namesMap.put("FO", "de Färrör-Enselle");
    namesMap.put("FR", "Frankrisch");
    namesMap.put("GA", "Jabuhn");
    namesMap.put("GB", "Jruußbrettannije");
    namesMap.put("GD", "Jrenaada");
    namesMap.put("GE", "Jeorrjije");
    namesMap.put("GF", "Franzüüsesch Jujaana");
    namesMap.put("GG", "Jöönsei");
    namesMap.put("GH", "Jaana");
    namesMap.put("GI", "Jibralltaa");
    namesMap.put("GL", "Jröhnland");
    namesMap.put("GM", "Jambija");
    namesMap.put("GN", "Jinneha");
    namesMap.put("GP", "Juadelupp");
    namesMap.put("GQ", "Äquatorial Jineeja");
    namesMap.put("GR", "Jriescheland");
    namesMap.put("GS", "Söd-Jeorjie un de södlijje Botteramms-Enselle");
    namesMap.put("GT", "Juwatemaala");
    namesMap.put("GU", "Juham");
    namesMap.put("GW", "Jinneha_Bißau");
    namesMap.put("GY", "Jujaana");
    namesMap.put("HK", "Hong-Kong");
    namesMap.put("HM", "de Heart Ensel un de McDonald-Enselle");
    namesMap.put("HR", "Krowazije");
    namesMap.put("HT", "Ha'itti");
    namesMap.put("HU", "Unjann");
    namesMap.put("IC", "de Kannaresche Enselle");
    namesMap.put("ID", "Indoneesije");
    namesMap.put("IE", "Irrland");
    namesMap.put("IL", "Ißraäl");
    namesMap.put("IM", "de Ensel Män");
    namesMap.put("IN", "Indije");
    namesMap.put("IO", "Brettesche Besezunge em indesche Oozejahn");
    namesMap.put("IQ", "der Irak");
    namesMap.put("IR", "Persije");
    namesMap.put("IS", "Ißland");
    namesMap.put("IT", "Itaalije");
    namesMap.put("JE", "Jööseh");
    namesMap.put("JM", "Jammaika");
    namesMap.put("JO", "Jordaanija");
    namesMap.put("KE", "Keenija");
    namesMap.put("KG", "Kirrjiisije");
    namesMap.put("KH", "Kambodscha");
    namesMap.put("KM", "de Kommoore");
    namesMap.put("KN", "Zimt Kitts un Nevis");
    namesMap.put("KP", "Nood-Koreja");
    namesMap.put("KR", "Söd-Koreja");
    namesMap.put("KW", "Kuweit");
    namesMap.put("KY", "de Kaiman-Enselle");
    namesMap.put("KZ", "Kassakstahn");
    namesMap.put("LA", "La'os");
    namesMap.put("LB", "der Lebbannon");
    namesMap.put("LC", "de Ensel Zint-Lutscha");
    namesMap.put("LI", "Lischtestein");
    namesMap.put("LR", "Libeerija");
    namesMap.put("LS", "Lesooto");
    namesMap.put("LT", "Littaue");
    namesMap.put("LU", "Luxembursch");
    namesMap.put("LV", "Lätland");
    namesMap.put("LY", "Libbije");
    namesMap.put("MA", "Marokko");
    namesMap.put("MC", "Monakko");
    namesMap.put("MD", "Moldaavije");
    namesMap.put("ME", "et Monteneejro");
    namesMap.put("MF", "de Sint-Määtes-Ensel");
    namesMap.put("MG", "Maddajaska");
    namesMap.put("MH", "de Machschall-Enselle");
    namesMap.put("MK", "Mazedoonije");
    namesMap.put("ML", "Maali");
    namesMap.put("MM", "Birma");
    namesMap.put("MN", "de Mongjolei");
    namesMap.put("MO", "Makau");
    namesMap.put("MP", "de nöödlijje Marijanne-Enselle");
    namesMap.put("MQ", "Machtinik");
    namesMap.put("MR", "Mautitaanije");
    namesMap.put("MS", "Mongßerrat");
    namesMap.put("MU", "Maurizijus");
    namesMap.put("MV", "de Mallediive");
    namesMap.put("MY", "Malaisije");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NA", "Namiibije");
    namesMap.put("NC", "Neuschottland");
    namesMap.put("NE", "Nijer");
    namesMap.put("NF", "de Noofok-Ensel");
    namesMap.put("NG", "Nikaraagua");
    namesMap.put("NI", "Nikaraaguwa");
    namesMap.put("NL", "de Nederläng");
    namesMap.put("NO", "Norrweeje");
    namesMap.put("NP", "Nepall");
    namesMap.put("NZ", "Neuseeland");
    namesMap.put("OM", "der Oman");
    namesMap.put("PA", "Pannama");
    namesMap.put("PE", "Perruh");
    namesMap.put("PF", "Franzüüsesch Pollineesije");
    namesMap.put("PG", "Papuwa Neujineeja");
    namesMap.put("PH", "de Fillipiine");
    namesMap.put("PK", "Pakistahn");
    namesMap.put("PL", "Pole");
    namesMap.put("PM", "Zint Pjäär un Mikelong");
    namesMap.put("PN", "de Pitkärn-Ensel");
    namesMap.put("PR", "Pochtoriko");
    namesMap.put("PS", "Palästina");
    namesMap.put("PT", "Pochtojall");
    namesMap.put("PW", "Pallau");
    namesMap.put("PY", "Parraguwai");
    namesMap.put("QA", "Kataa");
    namesMap.put("QO", "Ozejaanije ußerhallef");
    namesMap.put("RE", "Rehunjohn");
    namesMap.put("RO", "Romäänije");
    namesMap.put("RS", "Särbije");
    namesMap.put("RU", "Rußland");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudi Arraabije");
    namesMap.put("SB", "de Solomone-Enselle");
    namesMap.put("SC", "de Seischälle");
    namesMap.put("SD", "der Sudahn");
    namesMap.put("SE", "Schweede");
    namesMap.put("SG", "Singjapuur");
    namesMap.put("SH", "de Sint-Hellena-Ensel");
    namesMap.put("SI", "ßloveenije");
    namesMap.put("SJ", "de Enselle Svalbard un Jan Mayen");
    namesMap.put("SK", "de ẞlovakei");
    namesMap.put("SL", "Sjärra Lejone");
    namesMap.put("SM", "San-Marino");
    namesMap.put("SN", "der Sennejall");
    namesMap.put("SO", "Somaalije");
    namesMap.put("SR", "Sürinamm");
    namesMap.put("ST", "Zint Tommeh un Printschipe");
    namesMap.put("SV", "Äl Slavadoor");
    namesMap.put("SY", "Sürije");
    namesMap.put("SZ", "ßwaasiland");
    namesMap.put("TA", "Tristan da Cunja");
    namesMap.put("TC", "de Enselle Turks un Kaikos");
    namesMap.put("TD", "der Tschadd");
    namesMap.put("TF", "Franzüüsesche Södsee-Enselle");
    namesMap.put("TG", "Toojo");
    namesMap.put("TH", "Tailand");
    namesMap.put("TJ", "Tadschikistahn");
    namesMap.put("TL", "Oß-Timor");
    namesMap.put("TM", "Turkmenistahn");
    namesMap.put("TN", "Tuneesije");
    namesMap.put("TO", "Tongga");
    namesMap.put("TR", "de Törkei");
    namesMap.put("TT", "Trinidad un Tobääjo");
    namesMap.put("TZ", "Tansanija");
    namesMap.put("UA", "de Ukra'iine");
    namesMap.put("UG", "Ujanda");
    namesMap.put("UM", "de Vereineschte Schtaate vun Amärrika ier klein Enselsche ußerhallef");
    namesMap.put("US", "de Vereineschte Schtaate vun Ammärrika");
    namesMap.put("UY", "Urrujwai");
    namesMap.put("UZ", "Ußbeekistahn");
    namesMap.put("VA", "der Vattikahn");
    namesMap.put("VC", "Zint Vinzänz un de Jrenadines-Enselle");
    namesMap.put("VG", "de brettesche Juffer-Enselle");
    namesMap.put("VI", "de ammärrikahnesche Juffer-Enselle");
    namesMap.put("VN", "Vijätnamm");
    namesMap.put("WF", "Wallis un Futuna");
    namesMap.put("WS", "Sammoha");
    namesMap.put("YE", "der Jämme");
    namesMap.put("YT", "Majott");
    namesMap.put("ZA", "Södaffrika");
    namesMap.put("ZM", "Sambija");
    namesMap.put("ZW", "Simbabwe");
    namesMap.put("ZZ", "- Jääjend onbikannt -");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "de Ääd",
        "002": "Affrika",
        "003": "Nood-Amärrika",
        "005": "Söd-Amärrika",
        "009": "Ozejaanije",
        "011": "Wäß-Affrika",
        "013": "Meddelammärrika",
        "014": "Oß-Affrika",
        "015": "Nood-Affrika",
        "017": "Meddel-Affrika",
        "018": "Söd-Affrika",
        "019": "Ammärrika",
        "021": "der Norde vun Amärrika",
        "029": "de Karribik",
        "030": "Oß-Aasije",
        "034": "Söd-Aasije",
        "035": "Söd-Oß-Aasije",
        "039": "Söd-Europpa",
        "053": "de Rejjohn Austraalije",
        "054": "Mellaneesije",
        "057": "de Rejohn vun Mikroneeseje",
        "061": "Polineesije",
        "142": "Aasije",
        "143": "Meddelaasije",
        "145": "Wäß-Aasije",
        "150": "Europpa",
        "151": "Oß-Europpa",
        "154": "Nood-Europpa",
        "155": "Wäß-Europpa",
        "419": "Lateinamärrika",
        "AC": "Aßension",
        "AE": "Vereinschte Arrabesche Emmirate",
        "AF": "Afjaanistahn",
        "AG": "Antigwa un Barbuda",
        "AI": "Anggwilla",
        "AL": "Albaanije",
        "AM": "Arrmeenije",
        "AN": "de Nederlängsche Antille",
        "AO": "Angjoola",
        "AQ": "der Södpol",
        "AR": "Ajjentiinije",
        "AS": "Ammerikaanesch Sammoha",
        "AT": "Öösterisch",
        "AU": "Austraalije",
        "AX": "de Ohland-Enselle",
        "AZ": "Asserbaidschahn",
        "BA": "Boßnije",
        "BB": "de Ensel Barbados",
        "BD": "Bangladesch",
        "BE": "Bellje",
        "BF": "Bukkinna-Faase",
        "BG": "Bulljaarije",
        "BH": "Bachrain",
        "BJ": "dä Benin",
        "BL": "de Zint Battälmi-Enselle",
        "BM": "de Bermudas",
        "BO": "Bolliivije",
        "BR": "Brasilije",
        "BS": "de Bahamas",
        "BT": "Buttaan",
        "BV": "Buvee-Ensel",
        "BW": "Bozwaana",
        "BY": "Wießrußland",
        "CA": "Kannada",
        "CC": "de Kokkos-Enselle",
        "CD": "dä Konggo (Kinschasa)",
        "CF": "de Zäntraalaffrikaanesche Republik",
        "CG": "dä Konggo (Brassavill)",
        "CH": "de Schweiz",
        "CI": "Älfebeijn-Köß",
        "CK": "de Kuuk-Enselle",
        "CL": "Schiile",
        "CM": "Kammeruhn",
        "CN": "Schiina",
        "CO": "Kolumbije",
        "CP": "de Klipperton-Ensel",
        "CR": "Kostarika",
        "CU": "Kuba",
        "CV": "de Kapvärdesche Enselle",
        "CX": "de Weihnaachs-Ensel",
        "CY": "Züppere",
        "CZ": "de Tschäschei",
        "DE": "Doütschland",
        "DG": "de Diego-Garcia-Ensel",
        "DJ": "Dschibutti",
        "DK": "Dänemark",
        "DM": "Dominnika",
        "DO": "de Dommenekaanesche Reppublik",
        "DZ": "Alljeerije",
        "EA": "Ze'uta un Meliija",
        "EC": "Äkwador",
        "EE": "Äßland",
        "EG": "Äjüpte",
        "EH": "Wäß-Sahara",
        "ER": "Äritreja",
        "ES": "Schpaanije",
        "ET": "Ättijoopije",
        "EU": "de Eurppäesche Unijon",
        "FI": "Finnland",
        "FJ": "de Fidschi-Endelle",
        "FK": "de Falkland-Enselle",
        "FM": "Mikroneesije",
        "FO": "de Färrör-Enselle",
        "FR": "Frankrisch",
        "GA": "Jabuhn",
        "GB": "Jruußbrettannije",
        "GD": "Jrenaada",
        "GE": "Jeorrjije",
        "GF": "Franzüüsesch Jujaana",
        "GG": "Jöönsei",
        "GH": "Jaana",
        "GI": "Jibralltaa",
        "GL": "Jröhnland",
        "GM": "Jambija",
        "GN": "Jinneha",
        "GP": "Juadelupp",
        "GQ": "Äquatorial Jineeja",
        "GR": "Jriescheland",
        "GS": "Söd-Jeorjie un de södlijje Botteramms-Enselle",
        "GT": "Juwatemaala",
        "GU": "Juham",
        "GW": "Jinneha_Bißau",
        "GY": "Jujaana",
        "HK": "Hong-Kong",
        "HM": "de Heart Ensel un de McDonald-Enselle",
        "HR": "Krowazije",
        "HT": "Ha'itti",
        "HU": "Unjann",
        "IC": "de Kannaresche Enselle",
        "ID": "Indoneesije",
        "IE": "Irrland",
        "IL": "Ißraäl",
        "IM": "de Ensel Män",
        "IN": "Indije",
        "IO": "Brettesche Besezunge em indesche Oozejahn",
        "IQ": "der Irak",
        "IR": "Persije",
        "IS": "Ißland",
        "IT": "Itaalije",
        "JE": "Jööseh",
        "JM": "Jammaika",
        "JO": "Jordaanija",
        "KE": "Keenija",
        "KG": "Kirrjiisije",
        "KH": "Kambodscha",
        "KM": "de Kommoore",
        "KN": "Zimt Kitts un Nevis",
        "KP": "Nood-Koreja",
        "KR": "Söd-Koreja",
        "KW": "Kuweit",
        "KY": "de Kaiman-Enselle",
        "KZ": "Kassakstahn",
        "LA": "La'os",
        "LB": "der Lebbannon",
        "LC": "de Ensel Zint-Lutscha",
        "LI": "Lischtestein",
        "LR": "Libeerija",
        "LS": "Lesooto",
        "LT": "Littaue",
        "LU": "Luxembursch",
        "LV": "Lätland",
        "LY": "Libbije",
        "MA": "Marokko",
        "MC": "Monakko",
        "MD": "Moldaavije",
        "ME": "et Monteneejro",
        "MF": "de Sint-Määtes-Ensel",
        "MG": "Maddajaska",
        "MH": "de Machschall-Enselle",
        "MK": "Mazedoonije",
        "ML": "Maali",
        "MM": "Birma",
        "MN": "de Mongjolei",
        "MO": "Makau",
        "MP": "de nöödlijje Marijanne-Enselle",
        "MQ": "Machtinik",
        "MR": "Mautitaanije",
        "MS": "Mongßerrat",
        "MU": "Maurizijus",
        "MV": "de Mallediive",
        "MY": "Malaisije",
        "MZ": "Mosambik",
        "NA": "Namiibije",
        "NC": "Neuschottland",
        "NE": "Nijer",
        "NF": "de Noofok-Ensel",
        "NG": "Nikaraagua",
        "NI": "Nikaraaguwa",
        "NL": "de Nederläng",
        "NO": "Norrweeje",
        "NP": "Nepall",
        "NZ": "Neuseeland",
        "OM": "der Oman",
        "PA": "Pannama",
        "PE": "Perruh",
        "PF": "Franzüüsesch Pollineesije",
        "PG": "Papuwa Neujineeja",
        "PH": "de Fillipiine",
        "PK": "Pakistahn",
        "PL": "Pole",
        "PM": "Zint Pjäär un Mikelong",
        "PN": "de Pitkärn-Ensel",
        "PR": "Pochtoriko",
        "PS": "Palästina",
        "PT": "Pochtojall",
        "PW": "Pallau",
        "PY": "Parraguwai",
        "QA": "Kataa",
        "QO": "Ozejaanije ußerhallef",
        "RE": "Rehunjohn",
        "RO": "Romäänije",
        "RS": "Särbije",
        "RU": "Rußland",
        "RW": "Ruanda",
        "SA": "Saudi Arraabije",
        "SB": "de Solomone-Enselle",
        "SC": "de Seischälle",
        "SD": "der Sudahn",
        "SE": "Schweede",
        "SG": "Singjapuur",
        "SH": "de Sint-Hellena-Ensel",
        "SI": "ßloveenije",
        "SJ": "de Enselle Svalbard un Jan Mayen",
        "SK": "de ẞlovakei",
        "SL": "Sjärra Lejone",
        "SM": "San-Marino",
        "SN": "der Sennejall",
        "SO": "Somaalije",
        "SR": "Sürinamm",
        "ST": "Zint Tommeh un Printschipe",
        "SV": "Äl Slavadoor",
        "SY": "Sürije",
        "SZ": "ßwaasiland",
        "TA": "Tristan da Cunja",
        "TC": "de Enselle Turks un Kaikos",
        "TD": "der Tschadd",
        "TF": "Franzüüsesche Södsee-Enselle",
        "TG": "Toojo",
        "TH": "Tailand",
        "TJ": "Tadschikistahn",
        "TL": "Oß-Timor",
        "TM": "Turkmenistahn",
        "TN": "Tuneesije",
        "TO": "Tongga",
        "TR": "de Törkei",
        "TT": "Trinidad un Tobääjo",
        "TZ": "Tansanija",
        "UA": "de Ukra'iine",
        "UG": "Ujanda",
        "UM": "de Vereineschte Schtaate vun Amärrika ier klein Enselsche ußerhallef",
        "US": "de Vereineschte Schtaate vun Ammärrika",
        "UY": "Urrujwai",
        "UZ": "Ußbeekistahn",
        "VA": "der Vattikahn",
        "VC": "Zint Vinzänz un de Jrenadines-Enselle",
        "VG": "de brettesche Juffer-Enselle",
        "VI": "de ammärrikahnesche Juffer-Enselle",
        "VN": "Vijätnamm",
        "WF": "Wallis un Futuna",
        "WS": "Sammoha",
        "YE": "der Jämme",
        "YT": "Majott",
        "ZA": "Södaffrika",
        "ZM": "Sambija",
        "ZW": "Simbabwe",
        "ZZ": "- Jääjend onbikannt -"
    };
  }-*/;
}
