/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.authentication.web.HTTPAuthenticationScheme;
import org.picketlink.authentication.web.support.HTTPDigestUtil;
import org.picketlink.authentication.web.support.NonceCache;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.credential.Digest;

public class DigestAuthenticationScheme
implements HTTPAuthenticationScheme {
    public static final String REALM_NAME_INIT_PARAM = "realmName";
    public static final String DEFAULT_REALM_NAME = "PicketLink Default Realm";
    private final Timer nonceCleanupTimer = new Timer("PicketLink_Digest_Nonce_Cache_Cleanup");
    private final NonceCache nonceCache = new NonceCache();
    private String realm = "PicketLink Default Realm";

    @Override
    public void initialize(FilterConfig config) {
        String providedRealm = config.getInitParameter(REALM_NAME_INIT_PARAM);
        if (providedRealm != null) {
            this.realm = providedRealm;
        }
        this.nonceCleanupTimer.schedule((TimerTask)this.nonceCache, this.nonceCache.getNonceMaxValid(), this.nonceCache.getNonceMaxValid());
    }

    @Override
    public void extractCredential(HttpServletRequest request, DefaultLoginCredentials creds) {
        String[] tokens;
        if (this.isDigestAuthentication(request) && (tokens = this.extractTokens(request)).length > 0) {
            Digest credential = HTTPDigestUtil.digest(tokens);
            credential.setMethod(request.getMethod());
            if (this.nonceCache.hasValidNonce(credential, request)) {
                creds.setCredential(credential);
            }
        }
    }

    @Override
    public void challengeClient(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String domain = request.getContextPath();
        if (domain == null) {
            domain = "/";
        }
        String newNonce = this.nonceCache.generateAndCacheNonce(request);
        StringBuilder str = new StringBuilder("Digest realm=\"");
        str.append(this.realm).append("\",");
        str.append("domain=\"").append(domain).append("\",");
        str.append("nonce=\"").append(newNonce).append("\",");
        str.append("algorithm=MD5,");
        str.append("qop=").append("auth").append(",");
        str.append("stale=\"").append(false).append("\"");
        response.setHeader("WWW-Authenticate", str.toString());
        response.sendError(401);
    }

    @Override
    public boolean postAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }

    @Override
    public boolean isProtected(HttpServletRequest request) {
        return true;
    }

    private String[] extractTokens(HttpServletRequest request) {
        String authorizationHeader = this.getAuthorizationHeader(request).substring(7).trim();
        return authorizationHeader.split(",(?=(?:[^\"]*\"[^\"]*\")+$)");
    }

    private String getAuthorizationHeader(HttpServletRequest request) {
        return request.getHeader("Authorization");
    }

    private boolean isDigestAuthentication(HttpServletRequest request) {
        String authorizationHeader = this.getAuthorizationHeader(request);
        return authorizationHeader != null && authorizationHeader.startsWith("Digest ");
    }
}

