/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.restlet;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.restlet.ZNRecordUpdate;
import org.apache.helix.controller.restlet.ZkPropertyTransferApplication;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.log4j.Logger;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.engine.Engine;

public class ZKPropertyTransferServer {
    public static final String PORT = "port";
    public static String RESTRESOURCENAME = "ZNRecordUpdates";
    public static final String SERVER = "ZKPropertyTransferServer";
    public static int PERIOD = 10000;
    public static int MAX_UPDATE_LIMIT = 10000;
    private static Logger LOG = Logger.getLogger(ZKPropertyTransferServer.class);
    int _localWebservicePort;
    String _webserviceUrl;
    ZkBaseDataAccessor<ZNRecord> _accessor;
    String _zkAddress;
    AtomicReference<ConcurrentHashMap<String, ZNRecordUpdate>> _dataBufferRef = new AtomicReference();
    boolean _initialized = false;
    boolean _shutdownFlag = false;
    Component _component = null;
    Timer _timer = null;
    static ZKPropertyTransferServer _instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendData() {
        LOG.info((Object)"ZKPropertyTransferServer transfering data to zookeeper");
        ConcurrentHashMap updateCache = null;
        AtomicReference<ConcurrentHashMap<String, ZNRecordUpdate>> atomicReference = this._dataBufferRef;
        synchronized (atomicReference) {
            updateCache = this._dataBufferRef.getAndSet(new ConcurrentHashMap());
        }
        if (updateCache != null) {
            ArrayList<String> paths = new ArrayList<String>();
            ArrayList updaters = new ArrayList();
            ArrayList<ZNRecord> vals = new ArrayList<ZNRecord>();
            for (ZNRecordUpdate holder : updateCache.values()) {
                paths.add(holder.getPath());
                updaters.add(holder.getZNRecordUpdater());
                vals.add(holder.getRecord());
            }
            long timeStart = System.currentTimeMillis();
            if (paths.size() > 0) {
                this._accessor.updateChildren(paths, updaters, AccessOption.PERSISTENT);
            }
            LOG.info((Object)("ZKPropertyTransferServer updated " + vals.size() + " records in " + (System.currentTimeMillis() - timeStart) + " ms"));
        } else {
            LOG.warn((Object)"null _dataQueueRef. Should be in the beginning only");
        }
    }

    private ZKPropertyTransferServer() {
        this._dataBufferRef.getAndSet(new ConcurrentHashMap());
    }

    public static ZKPropertyTransferServer getInstance() {
        return _instance;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public void init(int localWebservicePort, String zkAddress) {
        if (!this._initialized && !this._shutdownFlag) {
            LOG.error((Object)("Initializing with port " + localWebservicePort + " zkAddress: " + zkAddress));
            this._localWebservicePort = localWebservicePort;
            ZkClient zkClient = new ZkClient(zkAddress);
            zkClient.setZkSerializer(new ZNRecordSerializer());
            this._accessor = new ZkBaseDataAccessor(zkClient);
            this._zkAddress = zkAddress;
            this.startServer();
        } else {
            LOG.error((Object)("Already initialized with port " + this._localWebservicePort + " shutdownFlag: " + this._shutdownFlag));
        }
    }

    public String getWebserviceUrl() {
        if (!this._initialized || this._shutdownFlag) {
            LOG.debug((Object)("inited:" + this._initialized + " shutdownFlag:" + this._shutdownFlag + " , return"));
            return null;
        }
        return this._webserviceUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueData(ZNRecordUpdate e) {
        if (!this._initialized || this._shutdownFlag) {
            LOG.error((Object)("zkDataTransferServer inited:" + this._initialized + " shutdownFlag:" + this._shutdownFlag + " , return"));
            return;
        }
        AtomicReference<ConcurrentHashMap<String, ZNRecordUpdate>> atomicReference = this._dataBufferRef;
        synchronized (atomicReference) {
            e.getRecord().setSimpleField(SERVER, this._webserviceUrl);
            if (this._dataBufferRef.get().containsKey(e.getPath())) {
                ZNRecord oldVal = this._dataBufferRef.get().get(e.getPath()).getRecord();
                this._dataBufferRef.get().get((Object)e.getPath())._record = oldVal = (ZNRecord)e.getZNRecordUpdater().update((Object)oldVal);
            } else {
                this._dataBufferRef.get().put(e.getPath(), e);
            }
        }
        if (this._dataBufferRef.get().size() > MAX_UPDATE_LIMIT) {
            this.sendData();
        }
    }

    void startServer() {
        LOG.info((Object)("zkDataTransferServer starting on Port " + this._localWebservicePort + " zkAddress " + this._zkAddress));
        this._component = new Component();
        this._component.getServers().add(Protocol.HTTP, this._localWebservicePort);
        Context applicationContext = this._component.getContext().createChildContext();
        applicationContext.getAttributes().put(SERVER, this);
        applicationContext.getAttributes().put(PORT, "" + this._localWebservicePort);
        ZkPropertyTransferApplication application = new ZkPropertyTransferApplication(applicationContext);
        this._component.getDefaultHost().attach((Restlet)application);
        this._timer = new Timer(true);
        this._timer.schedule((TimerTask)new ZKPropertyTransferTask(), PERIOD, (long)PERIOD);
        try {
            this._webserviceUrl = "http://" + InetAddress.getLocalHost().getCanonicalHostName() + ":" + this._localWebservicePort + "/" + RESTRESOURCENAME;
            this._component.start();
            this._initialized = true;
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
        LOG.info((Object)("zkDataTransferServer started on Port " + this._localWebservicePort + " zkAddress " + this._zkAddress));
    }

    public void shutdown() {
        if (this._shutdownFlag) {
            LOG.error((Object)"ZKPropertyTransferServer already has been shutdown...");
            return;
        }
        LOG.info((Object)("zkDataTransferServer shuting down on Port " + this._localWebservicePort + " zkAddress " + this._zkAddress));
        if (this._timer != null) {
            this._timer.cancel();
        }
        if (this._component != null) {
            try {
                this._component.stop();
            }
            catch (Exception e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }
        this._shutdownFlag = true;
    }

    public void reset() {
        if (this._shutdownFlag) {
            this._shutdownFlag = false;
            this._initialized = false;
            this._component = null;
            this._timer = null;
            this._dataBufferRef.getAndSet(new ConcurrentHashMap());
        }
    }

    static {
        Engine.setLogLevel((Level)Level.SEVERE);
        _instance = new ZKPropertyTransferServer();
    }

    class ZKPropertyTransferTask
    extends TimerTask {
        ZKPropertyTransferTask() {
        }

        @Override
        public void run() {
            try {
                ZKPropertyTransferServer.this.sendData();
            }
            catch (Throwable t) {
                LOG.error((Object)"", t);
            }
        }
    }
}

