/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkConnection;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ClusterMessagingService;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.ConfigChangeListener;
import org.apache.helix.ControllerChangeListener;
import org.apache.helix.CurrentStateChangeListener;
import org.apache.helix.ExternalViewChangeListener;
import org.apache.helix.HealthStateChangeListener;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerProperties;
import org.apache.helix.HelixTimerTask;
import org.apache.helix.IdealStateChangeListener;
import org.apache.helix.InstanceConfigChangeListener;
import org.apache.helix.InstanceType;
import org.apache.helix.LiveInstanceChangeListener;
import org.apache.helix.LiveInstanceInfoProvider;
import org.apache.helix.MessageListener;
import org.apache.helix.PreConnectCallback;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathConfig;
import org.apache.helix.PropertyType;
import org.apache.helix.ScopedConfigChangeListener;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.GenericHelixController;
import org.apache.helix.healthcheck.HealthStatsAggregationTask;
import org.apache.helix.healthcheck.HealthStatsAggregator;
import org.apache.helix.healthcheck.ParticipantHealthReportCollector;
import org.apache.helix.healthcheck.ParticipantHealthReportCollectorImpl;
import org.apache.helix.healthcheck.ParticipantHealthReportTask;
import org.apache.helix.manager.zk.CallbackHandler;
import org.apache.helix.manager.zk.ChainedPathZkSerializer;
import org.apache.helix.manager.zk.DistributedLeaderElection;
import org.apache.helix.manager.zk.ParticipantManagerHelper;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.manager.zk.ZNRecordStreamingSerializer;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.messaging.DefaultMessagingService;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.monitoring.ZKPathDataDumpTask;
import org.apache.helix.participant.HelixStateMachineEngine;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZKHelixManager
implements HelixManager,
IZkStateListener {
    private static Logger LOG = Logger.getLogger(ZKHelixManager.class);
    public static final int FLAPPING_TIME_WINDIOW = 300000;
    public static final int MAX_DISCONNECT_THRESHOLD = 5;
    public static final String ALLOW_PARTICIPANT_AUTO_JOIN = "allowParticipantAutoJoin";
    protected final String _zkAddress;
    private final String _clusterName;
    private final String _instanceName;
    private final InstanceType _instanceType;
    private final int _sessionTimeout;
    private final List<PreConnectCallback> _preConnectCallbacks;
    protected final List<CallbackHandler> _handlers;
    private final HelixManagerProperties _properties;
    private final String _version;
    protected ZkClient _zkclient = null;
    private final DefaultMessagingService _messagingService;
    private BaseDataAccessor<ZNRecord> _baseDataAccessor;
    private ZKHelixDataAccessor _dataAccessor;
    private final PropertyKey.Builder _keyBuilder;
    private ConfigAccessor _configAccessor;
    private ZkHelixPropertyStore<ZNRecord> _helixPropertyStore;
    protected LiveInstanceInfoProvider _liveInstanceInfoProvider = null;
    private volatile String _sessionId;
    private final List<Long> _disconnectTimeHistory = new ArrayList<Long>();
    private final int _flappingTimeWindowMs;
    private final int _maxDisconnectThreshold;
    private final StateMachineEngine _stateMachineEngine;
    private final ParticipantHealthReportCollectorImpl _participantHealthInfoCollector;
    private final List<HelixTimerTask> _timerTasks = new ArrayList<HelixTimerTask>();
    private final GenericHelixController _controller = new GenericHelixController();
    private CallbackHandler _leaderElectionHandler = null;
    protected final List<HelixTimerTask> _controllerTimerTasks = new ArrayList<HelixTimerTask>();

    public ZKHelixManager(String clusterName, String instanceName, InstanceType instanceType, String zkAddress) {
        LOG.info((Object)("Create a zk-based cluster manager. zkSvr: " + zkAddress + ", clusterName: " + clusterName + ", instanceName: " + instanceName + ", type: " + (Object)((Object)instanceType)));
        this._zkAddress = zkAddress;
        this._clusterName = clusterName;
        this._instanceType = instanceType;
        if (instanceName == null) {
            try {
                instanceName = InetAddress.getLocalHost().getCanonicalHostName() + "-" + instanceType.toString();
            }
            catch (UnknownHostException e) {
                LOG.info((Object)"Unable to get host name. Will set it to UNKNOWN, mostly ignorable", (Throwable)e);
                instanceName = "UNKNOWN";
            }
        }
        this._instanceName = instanceName;
        this._preConnectCallbacks = new ArrayList<PreConnectCallback>();
        this._handlers = new ArrayList<CallbackHandler>();
        this._properties = new HelixManagerProperties("cluster-manager-version.properties");
        this._version = this._properties.getVersion();
        this._keyBuilder = new PropertyKey.Builder(clusterName);
        this._messagingService = new DefaultMessagingService(this);
        this._flappingTimeWindowMs = this.getSystemPropertyAsInt("helixmanager.flappingTimeWindow", 300000);
        this._maxDisconnectThreshold = this.getSystemPropertyAsInt("helixmanager.maxDisconnectThreshold", 5);
        this._sessionTimeout = this.getSystemPropertyAsInt("zk.session.timeout", 30000);
        switch (instanceType) {
            case PARTICIPANT: {
                this._stateMachineEngine = new HelixStateMachineEngine(this);
                this._participantHealthInfoCollector = new ParticipantHealthReportCollectorImpl(this, this._instanceName);
                this._timerTasks.add(new ParticipantHealthReportTask(this._participantHealthInfoCollector));
                break;
            }
            case CONTROLLER: {
                this._stateMachineEngine = null;
                this._participantHealthInfoCollector = null;
                this._controllerTimerTasks.add(new HealthStatsAggregationTask(new HealthStatsAggregator(this)));
                this._controllerTimerTasks.add(new StatusDumpTask(this._zkclient, this));
                break;
            }
            case CONTROLLER_PARTICIPANT: {
                this._stateMachineEngine = new HelixStateMachineEngine(this);
                this._participantHealthInfoCollector = new ParticipantHealthReportCollectorImpl(this, this._instanceName);
                this._timerTasks.add(new ParticipantHealthReportTask(this._participantHealthInfoCollector));
                this._controllerTimerTasks.add(new HealthStatsAggregationTask(new HealthStatsAggregator(this)));
                this._controllerTimerTasks.add(new StatusDumpTask(this._zkclient, this));
                break;
            }
            case ADMINISTRATOR: 
            case SPECTATOR: {
                this._stateMachineEngine = null;
                this._participantHealthInfoCollector = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized type: " + (Object)((Object)instanceType));
            }
        }
    }

    private int getSystemPropertyAsInt(String propertyKey, int propertyDefaultValue) {
        String valueString = System.getProperty(propertyKey, "" + propertyDefaultValue);
        try {
            int value = Integer.parseInt(valueString);
            if (value > 0) {
                return value;
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Exception while parsing property: " + propertyKey + ", string: " + valueString + ", using default value: " + propertyDefaultValue));
        }
        return propertyDefaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(PropertyKey key, Object listener) {
        LOG.info((Object)("Removing listener: " + listener + " on path: " + key.getPath() + " from cluster: " + this._clusterName + " by instance: " + this._instanceName));
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            ArrayList<CallbackHandler> toRemove = new ArrayList<CallbackHandler>();
            for (CallbackHandler handler : this._handlers) {
                if (!handler.getPath().equals(key.getPath()) || !handler.getListener().equals(listener)) continue;
                toRemove.add(handler);
            }
            this._handlers.removeAll(toRemove);
            for (CallbackHandler handler : toRemove) {
                handler.reset();
            }
        }
        return true;
    }

    void checkConnected() {
        if (!this.isConnected()) {
            throw new HelixException("HelixManager is not connected. Call HelixManager#connect()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(Object listener, PropertyKey propertyKey, HelixConstants.ChangeType changeType, Watcher.Event.EventType[] eventType) {
        this.checkConnected();
        PropertyType type = propertyKey.getType();
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            for (CallbackHandler handler : this._handlers) {
                if (!handler.getPath().equals(propertyKey.getPath()) || !handler.getListener().equals(listener)) continue;
                LOG.info((Object)("Listener: " + listener + " on path: " + propertyKey.getPath() + " already exists. skip add"));
                return;
            }
            CallbackHandler newHandler = new CallbackHandler(this, this._zkclient, propertyKey, listener, eventType, changeType);
            this._handlers.add(newHandler);
            LOG.info((Object)("Added listener: " + listener + " for type: " + (Object)((Object)type) + " to path: " + newHandler.getPath()));
        }
    }

    @Override
    public void addIdealStateChangeListener(IdealStateChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).idealStates(), HelixConstants.ChangeType.IDEAL_STATE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeDataChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated});
    }

    @Override
    public void addLiveInstanceChangeListener(LiveInstanceChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).liveInstances(), HelixConstants.ChangeType.LIVE_INSTANCE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeDataChanged, Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated});
    }

    @Override
    public void addConfigChangeListener(ConfigChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).instanceConfigs(), HelixConstants.ChangeType.INSTANCE_CONFIG, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addInstanceConfigChangeListener(InstanceConfigChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).instanceConfigs(), HelixConstants.ChangeType.INSTANCE_CONFIG, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addConfigChangeListener(ScopedConfigChangeListener listener, HelixConfigScope.ConfigScopeProperty scope) throws Exception {
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(this._clusterName);
        PropertyKey propertyKey = null;
        switch (scope) {
            case CLUSTER: {
                propertyKey = keyBuilder.clusterConfigs();
                break;
            }
            case PARTICIPANT: {
                propertyKey = keyBuilder.instanceConfigs();
                break;
            }
            case RESOURCE: {
                propertyKey = keyBuilder.resourceConfigs();
                break;
            }
        }
        if (propertyKey != null) {
            this.addListener(listener, propertyKey, HelixConstants.ChangeType.CONFIG, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
        } else {
            LOG.error((Object)("Can't add listener to config scope: " + (Object)((Object)scope)));
        }
    }

    @Override
    public void addMessageListener(MessageListener listener, String instanceName) {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).messages(instanceName), HelixConstants.ChangeType.MESSAGE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated});
    }

    @Override
    public void addControllerMessageListener(MessageListener listener) {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).controllerMessages(), HelixConstants.ChangeType.MESSAGES_CONTROLLER, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated});
    }

    @Override
    public void addCurrentStateChangeListener(CurrentStateChangeListener listener, String instanceName, String sessionId) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).currentStates(instanceName, sessionId), HelixConstants.ChangeType.CURRENT_STATE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated});
    }

    @Override
    public void addHealthStateChangeListener(HealthStateChangeListener listener, String instanceName) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).healthReports(instanceName), HelixConstants.ChangeType.HEALTH, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated});
    }

    @Override
    public void addExternalViewChangeListener(ExternalViewChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).externalViews(), HelixConstants.ChangeType.EXTERNAL_VIEW, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated});
    }

    @Override
    public void addControllerListener(ControllerChangeListener listener) {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).controller(), HelixConstants.ChangeType.CONTROLLER, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated});
    }

    @Override
    public HelixDataAccessor getHelixDataAccessor() {
        this.checkConnected();
        return this._dataAccessor;
    }

    @Override
    public ConfigAccessor getConfigAccessor() {
        this.checkConnected();
        return this._configAccessor;
    }

    @Override
    public String getClusterName() {
        return this._clusterName;
    }

    @Override
    public String getInstanceName() {
        return this._instanceName;
    }

    BaseDataAccessor<ZNRecord> createBaseDataAccessor() {
        ZkBaseDataAccessor<ZNRecord> baseDataAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkclient);
        return baseDataAccessor;
    }

    void createClient() throws Exception {
        ChainedPathZkSerializer zkSerializer = ChainedPathZkSerializer.builder(new ZNRecordStreamingSerializer()).build();
        this._zkclient = new ZkClient(this._zkAddress, this._sessionTimeout, 60000, zkSerializer);
        this._baseDataAccessor = this.createBaseDataAccessor();
        this._dataAccessor = new ZKHelixDataAccessor(this._clusterName, this._instanceType, this._baseDataAccessor);
        this._configAccessor = new ConfigAccessor(this._zkclient);
        int retryCount = 0;
        this._zkclient.subscribeStateChanges(this);
        while (retryCount < 3) {
            try {
                this._zkclient.waitUntilConnected(this._sessionTimeout, TimeUnit.MILLISECONDS);
                this.handleStateChanged(Watcher.Event.KeeperState.SyncConnected);
                this.handleNewSession();
                break;
            }
            catch (HelixException e) {
                LOG.error((Object)"fail to createClient.", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)("fail to createClient. retry " + ++retryCount), (Throwable)e);
                if (retryCount != 3) continue;
                throw e;
            }
        }
    }

    @Override
    public void connect() throws Exception {
        LOG.info((Object)"ClusterManager.connect()");
        if (this.isConnected()) {
            LOG.warn((Object)("Cluster manager: " + this._instanceName + " for cluster: " + this._clusterName + " already connected. skip connect"));
            return;
        }
        try {
            this.createClient();
            this._messagingService.onConnected();
        }
        catch (Exception e) {
            LOG.error((Object)("fail to connect " + this._instanceName), (Throwable)e);
            this.disconnect();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (this._zkclient == null) {
            LOG.info((Object)("instanceName: " + this._instanceName + " already disconnected"));
            return;
        }
        LOG.info((Object)("disconnect " + this._instanceName + "(" + (Object)((Object)this._instanceType) + ") from " + this._clusterName));
        try {
            this.stopTimerTasks();
            this._messagingService.getExecutor().shutdown();
            this.resetHandlers();
            this._dataAccessor.shutdown();
            if (this._leaderElectionHandler != null) {
                this._leaderElectionHandler.reset();
            }
        }
        finally {
            this._zkclient.close();
            this._zkclient = null;
            LOG.info((Object)("Cluster manager: " + this._instanceName + " disconnected"));
        }
    }

    @Override
    public String getSessionId() {
        this.checkConnected();
        return this._sessionId;
    }

    @Override
    public boolean isConnected() {
        if (this._zkclient == null) {
            return false;
        }
        ZkConnection zkconnection = (ZkConnection)this._zkclient.getConnection();
        if (zkconnection != null) {
            ZooKeeper.States state = zkconnection.getZookeeperState();
            return state == ZooKeeper.States.CONNECTED;
        }
        return false;
    }

    @Override
    public long getLastNotificationTime() {
        return 0L;
    }

    @Override
    public void addPreConnectCallback(PreConnectCallback callback) {
        LOG.info((Object)("Adding preconnect callback: " + callback));
        this._preConnectCallbacks.add(callback);
    }

    @Override
    public boolean isLeader() {
        if (this._instanceType != InstanceType.CONTROLLER && this._instanceType != InstanceType.CONTROLLER_PARTICIPANT) {
            return false;
        }
        if (!this.isConnected()) {
            return false;
        }
        try {
            LiveInstance leader = (LiveInstance)this._dataAccessor.getProperty(this._keyBuilder.controllerLeader());
            if (leader != null) {
                String leaderName = leader.getInstanceName();
                String sessionId = leader.getSessionId();
                if (leaderName != null && leaderName.equals(this._instanceName) && sessionId != null && sessionId.equals(this._sessionId)) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized ZkHelixPropertyStore<ZNRecord> getHelixPropertyStore() {
        this.checkConnected();
        if (this._helixPropertyStore == null) {
            String path = PropertyPathConfig.getPath(PropertyType.PROPERTYSTORE, this._clusterName, new String[0]);
            this._helixPropertyStore = new ZkHelixPropertyStore(new ZkBaseDataAccessor(this._zkclient), path, null);
        }
        return this._helixPropertyStore;
    }

    @Override
    public synchronized HelixAdmin getClusterManagmentTool() {
        this.checkConnected();
        if (this._zkclient != null) {
            return new ZKHelixAdmin(this._zkclient);
        }
        LOG.error((Object)"Couldn't get ZKClusterManagementTool because zkclient is null");
        return null;
    }

    @Override
    public ClusterMessagingService getMessagingService() {
        return this._messagingService;
    }

    @Override
    public ParticipantHealthReportCollector getHealthReportCollector() {
        this.checkConnected();
        return this._participantHealthInfoCollector;
    }

    @Override
    public InstanceType getInstanceType() {
        return this._instanceType;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public HelixManagerProperties getProperties() {
        return this._properties;
    }

    @Override
    public StateMachineEngine getStateMachineEngine() {
        return this._stateMachineEngine;
    }

    @Override
    public void startTimerTasks() {
        for (HelixTimerTask task : this._timerTasks) {
            task.start();
        }
    }

    @Override
    public void stopTimerTasks() {
        for (HelixTimerTask task : this._timerTasks) {
            task.stop();
        }
    }

    @Override
    public void setLiveInstanceInfoProvider(LiveInstanceInfoProvider liveInstanceInfoProvider) {
        this._liveInstanceInfoProvider = liveInstanceInfoProvider;
    }

    void waitUntilConnected() {
        do {
            boolean isConnected;
            if (!(isConnected = this._zkclient.waitUntilConnected(60000L, TimeUnit.MILLISECONDS))) {
                LOG.error((Object)("fail to connect zkserver: " + this._zkAddress + " in " + 60000 + "ms. expiredSessionId: " + this._sessionId + ", clusterName: " + this._clusterName));
                continue;
            }
            ZkConnection zkConnection = (ZkConnection)this._zkclient.getConnection();
            this._sessionId = Long.toHexString(zkConnection.getZookeeper().getSessionId());
        } while ("0".equals(this._sessionId));
        LOG.info((Object)("Handling new session, session id: " + this._sessionId + ", instance: " + this._instanceName + ", instanceTye: " + (Object)((Object)this._instanceType) + ", cluster: " + this._clusterName + ", zkconnection: " + ((ZkConnection)this._zkclient.getConnection()).getZookeeper()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initHandlers(List<CallbackHandler> handlers) {
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            if (handlers != null) {
                for (CallbackHandler handler : handlers) {
                    handler.init();
                    LOG.info((Object)("init handler: " + handler.getPath() + ", " + handler.getListener()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetHandlers() {
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            if (this._handlers != null) {
                ArrayList<CallbackHandler> tmpHandlers = new ArrayList<CallbackHandler>();
                tmpHandlers.addAll(this._handlers);
                for (CallbackHandler handler : tmpHandlers) {
                    handler.reset();
                    LOG.info((Object)("reset handler: " + handler.getPath() + ", " + handler.getListener()));
                }
            }
        }
    }

    boolean isFlapping() {
        if (this._disconnectTimeHistory.size() == 0) {
            return false;
        }
        long mostRecentTimestamp = this._disconnectTimeHistory.get(this._disconnectTimeHistory.size() - 1);
        while (this._disconnectTimeHistory.get(0) + (long)this._flappingTimeWindowMs < mostRecentTimestamp) {
            this._disconnectTimeHistory.remove(0);
        }
        return this._disconnectTimeHistory.size() > this._maxDisconnectThreshold;
    }

    public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
        switch (state) {
            case SyncConnected: {
                ZkConnection zkConnection = (ZkConnection)this._zkclient.getConnection();
                LOG.info((Object)("KeeperState: " + state + ", zookeeper:" + zkConnection.getZookeeper()));
                break;
            }
            case Disconnected: {
                LOG.info((Object)("KeeperState:" + state + ", disconnectedSessionId: " + this._sessionId + ", instance: " + this._instanceName + ", type: " + (Object)((Object)this._instanceType)));
                this._disconnectTimeHistory.add(System.currentTimeMillis());
                if (!this.isFlapping()) break;
                LOG.error((Object)("instanceName: " + this._instanceName + " is flapping. diconnect it. " + " maxDisconnectThreshold: " + this._maxDisconnectThreshold + " disconnects in " + this._flappingTimeWindowMs + "ms."));
                this.disconnect();
                break;
            }
            case Expired: {
                LOG.info((Object)("KeeperState:" + state + ", expiredSessionId: " + this._sessionId + ", instance: " + this._instanceName + ", type: " + (Object)((Object)this._instanceType)));
                break;
            }
        }
    }

    public void handleNewSession() throws Exception {
        this.waitUntilConnected();
        this.stopTimerTasks();
        if (this._leaderElectionHandler != null) {
            this._leaderElectionHandler.reset();
        }
        this.resetHandlers();
        this._baseDataAccessor.reset();
        if (!ZKUtil.isClusterSetup(this._clusterName, this._zkclient)) {
            throw new HelixException("Cluster structure is not set up for cluster: " + this._clusterName);
        }
        switch (this._instanceType) {
            case PARTICIPANT: {
                this.handleNewSessionAsParticipant();
                break;
            }
            case CONTROLLER: {
                this.handleNewSessionAsController();
                break;
            }
            case CONTROLLER_PARTICIPANT: {
                this.handleNewSessionAsParticipant();
                this.handleNewSessionAsController();
                break;
            }
        }
        this.startTimerTasks();
        this.initHandlers(this._handlers);
    }

    void handleNewSessionAsParticipant() throws Exception {
        ParticipantManagerHelper participantHelper = new ParticipantManagerHelper(this, this._zkclient, this._sessionTimeout, this._liveInstanceInfoProvider);
        participantHelper.joinCluster();
        for (PreConnectCallback callback : this._preConnectCallbacks) {
            callback.onPreConnect();
        }
        participantHelper.createLiveInstance();
        participantHelper.carryOverPreviousCurrentState();
        participantHelper.setupMsgHandler();
        participantHelper.createHealthCheckPath();
    }

    void handleNewSessionAsController() {
        if (this._leaderElectionHandler != null) {
            this._leaderElectionHandler.init();
        } else {
            this._leaderElectionHandler = new CallbackHandler(this, this._zkclient, this._keyBuilder.controller(), new DistributedLeaderElection(this, this._controller, this._controllerTimerTasks), new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated}, HelixConstants.ChangeType.CONTROLLER);
        }
    }

    static class StatusDumpTask
    extends HelixTimerTask {
        Timer _timer = null;
        final ZkClient zkclient;
        final HelixManager helixController;

        public StatusDumpTask(ZkClient zkclient, HelixManager helixController) {
            this.zkclient = zkclient;
            this.helixController = helixController;
        }

        @Override
        public void start() {
            long initialDelay = 1800000L;
            long period = 0x6DDD00L;
            int timeThresholdNoChange = 10800000;
            if (this._timer == null) {
                LOG.info((Object)"Start StatusDumpTask");
                this._timer = new Timer("StatusDumpTimerTask", true);
                this._timer.scheduleAtFixedRate((TimerTask)new ZKPathDataDumpTask(this.helixController, this.zkclient, timeThresholdNoChange), initialDelay, period);
            }
        }

        @Override
        public void stop() {
            if (this._timer != null) {
                LOG.info((Object)"Stop StatusDumpTask");
                this._timer.cancel();
                this._timer = null;
            }
        }
    }
}

