/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecordBucketizer;
import org.apache.helix.ZNRecordDelta;
import org.apache.helix.messaging.handling.CurrentStateUpdate;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.participant.statemachine.StateModelParser;
import org.apache.helix.participant.statemachine.StateTransitionError;
import org.apache.helix.util.StatusUpdateUtil;
import org.apache.log4j.Logger;

public class HelixStateTransitionHandler
extends MessageHandler {
    private static Logger logger = Logger.getLogger(HelixStateTransitionHandler.class);
    private final StateModel _stateModel;
    StatusUpdateUtil _statusUpdateUtil;
    private final StateModelParser _transitionMethodFinder;
    private final CurrentState _currentStateDelta;
    private final HelixManager _manager;
    private final StateModelFactory<? extends StateModel> _stateModelFactory;
    volatile boolean _isTimeout = false;

    public HelixStateTransitionHandler(StateModelFactory<? extends StateModel> stateModelFactory, StateModel stateModel, Message message, NotificationContext context, CurrentState currentStateDelta) {
        super(message, context);
        this._stateModel = stateModel;
        this._statusUpdateUtil = new StatusUpdateUtil();
        this._transitionMethodFinder = new StateModelParser();
        this._currentStateDelta = currentStateDelta;
        this._manager = this._notificationContext.getManager();
        this._stateModelFactory = stateModelFactory;
    }

    void preHandleMessage() throws Exception {
        if (!this._message.isValid()) {
            String errorMessage = "Invalid Message, ensure that message: " + this._message + " has all the required fields: " + Arrays.toString((Object[])Message.Attributes.values());
            this._statusUpdateUtil.logError(this._message, HelixStateTransitionHandler.class, errorMessage, this._manager.getHelixDataAccessor());
            logger.error((Object)errorMessage);
            throw new HelixException(errorMessage);
        }
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        String partitionName = this._message.getPartitionName();
        String fromState = this._message.getFromState();
        String state = this._currentStateDelta.getState(partitionName);
        if (fromState != null && !fromState.equals("*") && !fromState.equalsIgnoreCase(state)) {
            String errorMessage = "Current state of stateModel does not match the fromState in Message, Current State:" + state + ", message expected:" + fromState + ", partition: " + partitionName + ", from: " + this._message.getMsgSrc() + ", to: " + this._message.getTgtName();
            this._statusUpdateUtil.logError(this._message, HelixStateTransitionHandler.class, errorMessage, accessor);
            logger.error((Object)errorMessage);
            throw new HelixStateMismatchException(errorMessage);
        }
    }

    void postHandleMessage() {
        HelixTaskResult taskResult = (HelixTaskResult)this._notificationContext.get(NotificationContext.MapKey.HELIX_TASK_RESULT.toString());
        Exception exception = taskResult.getException();
        String partitionKey = this._message.getPartitionName();
        String resource = this._message.getResourceName();
        String sessionId = this._message.getTgtSessionId();
        String instanceName = this._manager.getInstanceName();
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        int bucketSize = this._message.getBucketSize();
        ZNRecordBucketizer bucketizer = new ZNRecordBucketizer(bucketSize);
        if (!this._message.getTgtSessionId().equals(this._manager.getSessionId())) {
            logger.warn((Object)("Session id has changed. Skip postExecutionMessage. Old session " + this._message.getExecutionSessionId() + " , new session : " + this._manager.getSessionId()));
            return;
        }
        if (taskResult.isSuccess()) {
            String toState = this._message.getToState();
            this._currentStateDelta.setState(partitionKey, toState);
            if (toState.equalsIgnoreCase(HelixDefinedState.DROPPED.toString())) {
                ZNRecordDelta delta = new ZNRecordDelta(this._currentStateDelta.getRecord(), ZNRecordDelta.MergeOperation.SUBTRACT);
                delta._record.getSimpleFields().clear();
                ArrayList<ZNRecordDelta> deltaList = new ArrayList<ZNRecordDelta>();
                deltaList.add(delta);
                this._currentStateDelta.setDeltaList(deltaList);
                this._stateModelFactory.removeStateModel(partitionKey);
            } else {
                this._stateModel.updateState(toState);
            }
        } else if (exception instanceof HelixStateMismatchException) {
            logger.warn((Object)("Force CurrentState on Zk to be stateModel's CurrentState. partitionKey: " + partitionKey + ", currentState: " + this._stateModel.getCurrentState() + ", message: " + this._message));
            this._currentStateDelta.setState(partitionKey, this._stateModel.getCurrentState());
        } else {
            StateTransitionError error = new StateTransitionError(MessageHandler.ErrorType.INTERNAL, MessageHandler.ErrorCode.ERROR, exception);
            if (exception instanceof InterruptedException) {
                if (this._isTimeout) {
                    error = new StateTransitionError(MessageHandler.ErrorType.INTERNAL, MessageHandler.ErrorCode.TIMEOUT, exception);
                } else {
                    logger.error((Object)("State transition interrupted but not timeout. Not updating state. Partition : " + this._message.getPartitionName() + " MsgId : " + this._message.getMsgId()));
                    return;
                }
            }
            this._stateModel.rollbackOnError(this._message, this._notificationContext, error);
            this._currentStateDelta.setState(partitionKey, HelixDefinedState.ERROR.toString());
            this._stateModel.updateState(HelixDefinedState.ERROR.toString());
            if (this._message.getFromState().equalsIgnoreCase(HelixDefinedState.ERROR.toString())) {
                this.disablePartition();
            }
        }
        try {
            PropertyKey key = keyBuilder.currentState(instanceName, sessionId, resource, bucketizer.getBucketName(partitionKey));
            if (this._message.getAttribute(Message.Attributes.PARENT_MSG_ID) == null) {
                accessor.updateProperty(key, this._currentStateDelta);
            } else {
                ConcurrentHashMap csUpdateMap = (ConcurrentHashMap)this._notificationContext.get(NotificationContext.MapKey.CURRENT_STATE_UPDATE.toString());
                csUpdateMap.put(partitionKey, new CurrentStateUpdate(key, this._currentStateDelta));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error when updating current-state ", (Throwable)e);
            StateTransitionError error = new StateTransitionError(MessageHandler.ErrorType.FRAMEWORK, MessageHandler.ErrorCode.ERROR, e);
            this._stateModel.rollbackOnError(this._message, this._notificationContext, error);
            this._statusUpdateUtil.logError(this._message, HelixStateTransitionHandler.class, e, "Error when update current-state ", accessor);
        }
    }

    void disablePartition() {
        String instanceName = this._manager.getInstanceName();
        String resourceName = this._message.getResourceName();
        String partitionName = this._message.getPartitionName();
        String clusterName = this._manager.getClusterName();
        HelixAdmin admin = this._manager.getClusterManagmentTool();
        admin.enablePartition(false, clusterName, instanceName, resourceName, Arrays.asList(partitionName));
        logger.info((Object)("error in transit from ERROR to " + this._message.getToState() + " for partition: " + partitionName + ". disable it on " + instanceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HelixTaskResult handleMessage() {
        NotificationContext context = this._notificationContext;
        Message message = this._message;
        StateModel stateModel = this._stateModel;
        synchronized (stateModel) {
            HelixTaskResult taskResult = new HelixTaskResult();
            HelixManager manager = context.getManager();
            HelixDataAccessor accessor = manager.getHelixDataAccessor();
            this._statusUpdateUtil.logInfo(message, HelixStateTransitionHandler.class, "Message handling task begin execute", accessor);
            message.setExecuteStartTimeStamp(new Date().getTime());
            try {
                this.preHandleMessage();
                this.invoke(accessor, context, taskResult, message);
            }
            catch (HelixStateMismatchException e) {
                taskResult.setSuccess(false);
                taskResult.setMessage(e.toString());
                taskResult.setException(e);
            }
            catch (Exception e2) {
                InterruptedException e2;
                String errorMessage = "Exception while executing a state transition task " + message.getPartitionName();
                logger.error((Object)errorMessage, (Throwable)e2);
                if (e2.getCause() != null && e2.getCause() instanceof InterruptedException) {
                    e2 = (InterruptedException)e2.getCause();
                }
                this._statusUpdateUtil.logError(message, HelixStateTransitionHandler.class, e2, errorMessage, accessor);
                taskResult.setSuccess(false);
                taskResult.setMessage(e2.toString());
                taskResult.setException(e2);
                taskResult.setInterrupted(e2 instanceof InterruptedException);
            }
            context.add(NotificationContext.MapKey.HELIX_TASK_RESULT.toString(), taskResult);
            this.postHandleMessage();
            return taskResult;
        }
    }

    private void invoke(HelixDataAccessor accessor, NotificationContext context, HelixTaskResult taskResult, Message message) throws IllegalAccessException, InvocationTargetException, InterruptedException {
        this._statusUpdateUtil.logInfo(message, HelixStateTransitionHandler.class, "Message handling invoking", accessor);
        Method methodToInvoke = null;
        String fromState = message.getFromState();
        String toState = message.getToState();
        methodToInvoke = this._transitionMethodFinder.getMethodForTransition(this._stateModel.getClass(), fromState, toState, new Class[]{Message.class, NotificationContext.class});
        if (methodToInvoke != null) {
            methodToInvoke.invoke((Object)this._stateModel, message, context);
            taskResult.setSuccess(true);
        } else {
            String errorMessage = "Unable to find method for transition from " + fromState + " to " + toState + " in " + this._stateModel.getClass();
            logger.error((Object)errorMessage);
            taskResult.setSuccess(false);
            this._statusUpdateUtil.logError(message, HelixStateTransitionHandler.class, errorMessage, accessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        String instanceName = this._manager.getInstanceName();
        String resourceName = this._message.getResourceName();
        String partition = this._message.getPartitionName();
        if (type == MessageHandler.ErrorType.INTERNAL) {
            logger.error((Object)("Skip internal error. errCode: " + (Object)((Object)code) + ", errMsg: " + e.getMessage()));
            return;
        }
        try {
            if (code == MessageHandler.ErrorCode.ERROR) {
                CurrentState currentStateDelta = new CurrentState(resourceName);
                currentStateDelta.setState(partition, HelixDefinedState.ERROR.toString());
                this._stateModel.updateState(HelixDefinedState.ERROR.toString());
                if (this._message.getFromState().equalsIgnoreCase(HelixDefinedState.ERROR.toString())) {
                    this.disablePartition();
                }
                accessor.updateProperty(keyBuilder.currentState(instanceName, this._message.getTgtSessionId(), resourceName), currentStateDelta);
            }
        }
        finally {
            StateTransitionError error = new StateTransitionError(type, code, e);
            this._stateModel.rollbackOnError(this._message, this._notificationContext, error);
        }
    }

    @Override
    public void onTimeout() {
        this._isTimeout = true;
    }

    public static class HelixStateMismatchException
    extends Exception {
        public HelixStateMismatchException(String info) {
            super(info);
        }
    }
}

