/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.PropertyPathConfig;
import org.apache.helix.PropertyType;
import org.apache.log4j.Logger;

public final class HelixUtil {
    private static Logger LOG = Logger.getLogger(HelixUtil.class);

    private HelixUtil() {
    }

    public static String getPropertyPath(String clusterName, PropertyType type) {
        return "/" + clusterName + "/" + type.toString();
    }

    public static String getInstancePropertyPath(String clusterName, String instanceName, PropertyType type) {
        return HelixUtil.getPropertyPath(clusterName, PropertyType.INSTANCES) + "/" + instanceName + "/" + type.toString();
    }

    public static String getInstancePath(String clusterName, String instanceName) {
        return HelixUtil.getPropertyPath(clusterName, PropertyType.INSTANCES) + "/" + instanceName;
    }

    public static String getIdealStatePath(String clusterName, String resourceName) {
        return HelixUtil.getPropertyPath(clusterName, PropertyType.IDEALSTATES) + "/" + resourceName;
    }

    public static String getIdealStatePath(String clusterName) {
        return HelixUtil.getPropertyPath(clusterName, PropertyType.IDEALSTATES);
    }

    public static String getLiveInstancesPath(String clusterName) {
        return HelixUtil.getPropertyPath(clusterName, PropertyType.LIVEINSTANCES);
    }

    public static String getMessagePath(String clusterName, String instanceName) {
        return HelixUtil.getInstancePropertyPath(clusterName, instanceName, PropertyType.MESSAGES);
    }

    public static String getCurrentStateBasePath(String clusterName, String instanceName) {
        return HelixUtil.getInstancePropertyPath(clusterName, instanceName, PropertyType.CURRENTSTATES);
    }

    public static String getCurrentStatePath(String clusterName, String instanceName, String sessionId, String stateUnitKey) {
        return HelixUtil.getInstancePropertyPath(clusterName, instanceName, PropertyType.CURRENTSTATES) + "/" + sessionId + "/" + stateUnitKey;
    }

    public static String getExternalViewPath(String clusterName) {
        return HelixUtil.getPropertyPath(clusterName, PropertyType.EXTERNALVIEW);
    }

    public static String getStateModelDefinitionPath(String clusterName) {
        return HelixUtil.getPropertyPath(clusterName, PropertyType.STATEMODELDEFS);
    }

    public static String getExternalViewPath(String clusterName, String resourceName) {
        return HelixUtil.getPropertyPath(clusterName, PropertyType.EXTERNALVIEW) + "/" + resourceName;
    }

    public static String getLiveInstancePath(String clusterName, String instanceName) {
        return HelixUtil.getPropertyPath(clusterName, PropertyType.LIVEINSTANCES) + "/" + instanceName;
    }

    public static String getMemberInstancesPath(String clusterName) {
        return HelixUtil.getPropertyPath(clusterName, PropertyType.INSTANCES);
    }

    public static String getErrorsPath(String clusterName, String instanceName) {
        return HelixUtil.getInstancePropertyPath(clusterName, instanceName, PropertyType.ERRORS);
    }

    public static String getStatusUpdatesPath(String clusterName, String instanceName) {
        return HelixUtil.getInstancePropertyPath(clusterName, instanceName, PropertyType.STATUSUPDATES);
    }

    public static String getHealthPath(String clusterName, String instanceName) {
        return PropertyPathConfig.getPath(PropertyType.HEALTHREPORT, clusterName, instanceName);
    }

    public static String getPersistentStatsPath(String clusterName) {
        return PropertyPathConfig.getPath(PropertyType.PERSISTENTSTATS, clusterName, new String[0]);
    }

    public static String getAlertsPath(String clusterName) {
        return PropertyPathConfig.getPath(PropertyType.ALERTS, clusterName, new String[0]);
    }

    public static String getAlertStatusPath(String clusterName) {
        return PropertyPathConfig.getPath(PropertyType.ALERT_STATUS, clusterName, new String[0]);
    }

    public static String getInstanceNameFromPath(String path) {
        String[] split;
        if (path.contains("/" + (Object)((Object)PropertyType.INSTANCES) + "/") && (split = path.split("\\/")).length > 3) {
            return split[3];
        }
        return null;
    }

    public static String getControllerPath(String clusterName) {
        return HelixUtil.getPropertyPath(clusterName, PropertyType.CONTROLLER);
    }

    public static String getControllerPropertyPath(String clusterName, PropertyType type) {
        return PropertyPathConfig.getPath(type, clusterName, new String[0]);
    }

    public static String getZkParentPath(String path) {
        if (path.equals("/")) {
            return null;
        }
        int idx = path.lastIndexOf(47);
        return idx == 0 ? "/" : path.substring(0, idx);
    }

    public static String getZkName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static Map<String, String> parseCsvFormatedKeyValuePairs(String keyValuePairs) {
        String[] pairs = keyValuePairs.split("[\\s,]");
        TreeMap<String, String> keyValueMap = new TreeMap<String, String>();
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                LOG.error((Object)("Invalid key-value pair: " + pair + ". Igonore it."));
                continue;
            }
            String key = pair.substring(0, idx);
            String value = pair.substring(idx + 1);
            keyValueMap.put(key, value);
        }
        return keyValueMap;
    }

    public static <T> Class<?> loadClass(Class<T> clazz, String className) throws ClassNotFoundException {
        try {
            return clazz.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            throw ex;
        }
    }
}

