/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataSource;

public class GZIPFileDataSource
implements DataSource {
    private File file = null;
    private String zipExtension = ".gz";

    public GZIPFileDataSource(File f, String zipExtension) {
        this.file = f;
        if (zipExtension != null) {
            this.zipExtension = zipExtension.toLowerCase();
        }
    }

    public String getContentType() {
        String fName = this.file.getName().toLowerCase();
        if (fName.indexOf(this.zipExtension) != -1) {
            fName = fName.substring(0, fName.indexOf(this.zipExtension));
        }
        if (fName.endsWith(".doc")) {
            return "application/msword";
        }
        if (fName.endsWith(".sdw")) {
            return "application/x-swriter";
        }
        if (fName.endsWith(".rtf")) {
            return "text/rtf";
        }
        if (fName.endsWith(".html")) {
            return "text/html";
        }
        if (fName.endsWith(".txt")) {
            return "text/plain";
        }
        return "application/octet-stream";
    }

    public InputStream getInputStream() throws IOException {
        return new GZIPInputStream(new BufferedInputStream(new FileInputStream(this.file)));
    }

    public OutputStream getOutputStream() throws IOException {
        return new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
    }

    public void setZipExtension(String ext) {
        this.zipExtension = ext;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        String fName = this.file.getName().toLowerCase();
        if (fName.indexOf(this.zipExtension) != -1) {
            fName = fName.substring(0, fName.indexOf(this.zipExtension));
        }
        return fName;
    }
}

