/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl.graphmatching;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.clerezza.rdf.core.impl.graphmatching.GraphNotIsomorphicException;
import org.apache.clerezza.rdf.core.impl.graphmatching.GroupMappingIterator;
import org.apache.clerezza.rdf.core.impl.graphmatching.HashMatching;
import org.apache.clerezza.rdf.core.impl.graphmatching.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMatcher {
    private static final Logger log = LoggerFactory.getLogger(GraphMatcher.class);

    public static Map<BNode, BNode> getValidMapping(TripleCollection og1, TripleCollection og2) {
        HashMatching hashMatching;
        SimpleMGraph g1 = new SimpleMGraph(og1);
        SimpleMGraph g2 = new SimpleMGraph(og2);
        if (!Utils.removeGrounded(g1, g2)) {
            return null;
        }
        try {
            hashMatching = new HashMatching(g1, g2);
        }
        catch (GraphNotIsomorphicException ex) {
            return null;
        }
        Map<BNode, BNode> matchings = hashMatching.getMatchings();
        if (g1.size() > 0) {
            Map<BNode, BNode> remainingMappings = GraphMatcher.trialAndErrorMatching(g1, g2, hashMatching.getMatchingGroups());
            if (remainingMappings == null) {
                return null;
            }
            matchings.putAll(remainingMappings);
        }
        return matchings;
    }

    private static Map<BNode, BNode> trialAndErrorMatching(MGraph g1, MGraph g2, Map<Set<BNode>, Set<BNode>> matchingGroups) {
        if (log.isDebugEnabled()) {
            Set<BNode> bn1 = Utils.getBNodes(g1);
            log.debug("doing trial and error matching for {} bnodes, in graphs of size: {}.", (Object)bn1.size(), (Object)g1.size());
        }
        Iterator mappingIter = GroupMappingIterator.create(matchingGroups);
        while (mappingIter.hasNext()) {
            Map<BNode, BNode> map = mappingIter.next();
            if (!GraphMatcher.checkMapping(g1, g2, map)) continue;
            return map;
        }
        return null;
    }

    private static boolean checkMapping(MGraph g1, MGraph g2, Map<BNode, BNode> map) {
        for (Triple triple : g1) {
            if (g2.contains(GraphMatcher.map(triple, map))) continue;
            return false;
        }
        return true;
    }

    private static Triple map(Triple triple, Map<BNode, BNode> map) {
        NonLiteral oSubject = triple.getSubject();
        NonLiteral subject = oSubject instanceof BNode ? (NonLiteral)map.get((BNode)oSubject) : oSubject;
        Resource oObject = triple.getObject();
        Resource object = oObject instanceof BNode ? (Resource)map.get((BNode)oObject) : oObject;
        return new TripleImpl(subject, triple.getPredicate(), object);
    }
}

