/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.serializedform;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.serializedform.SerializingProvider;
import org.apache.clerezza.rdf.core.serializedform.SupportedFormat;
import org.apache.clerezza.rdf.core.serializedform.UnsupportedFormatException;
import org.apache.clerezza.rdf.core.serializedform.UnsupportedSerializationFormatException;

public class Serializer {
    private List<SerializingProvider> providerList = new ArrayList<SerializingProvider>();
    private volatile Map<String, SerializingProvider> providerMap = new HashMap<String, SerializingProvider>();
    private static volatile Serializer instance;

    public Serializer() {
        instance = this;
    }

    Serializer(Object dummy) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Serializer getInstance() {
        if (instance != null) return instance;
        Class<Serializer> clazz = Serializer.class;
        synchronized (Serializer.class) {
            if (instance != null) return instance;
            new Serializer();
            for (SerializingProvider SerializingProvider2 : ServiceLoader.load(SerializingProvider.class)) {
                instance.bindSerializingProvider(SerializingProvider2);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void serialize(OutputStream serializedGraph, TripleCollection tc, String formatIdentifier) throws UnsupportedFormatException {
        int semicolonPos = formatIdentifier.indexOf(59);
        String deParameterizedIdentifier = semicolonPos > -1 ? formatIdentifier.substring(0, semicolonPos) : formatIdentifier;
        SerializingProvider provider = this.providerMap.get(deParameterizedIdentifier);
        if (provider == null) {
            throw new UnsupportedSerializationFormatException(formatIdentifier);
        }
        provider.serialize(serializedGraph, tc, formatIdentifier);
    }

    public void bindSerializingProvider(SerializingProvider provider) {
        this.providerList.add(provider);
        this.refreshProviderMap();
    }

    public void unbindSerializingProvider(SerializingProvider provider) {
        this.providerList.remove(provider);
        this.refreshProviderMap();
    }

    private void refreshProviderMap() {
        HashMap<String, SerializingProvider> newProviderMap = new HashMap<String, SerializingProvider>();
        Collections.sort(this.providerList, new Comparator<SerializingProvider>(){

            @Override
            public int compare(SerializingProvider s1, SerializingProvider s2) {
                return Serializer.this.getFormatIdentifiers(s2).length - Serializer.this.getFormatIdentifiers(s1).length;
            }
        });
        for (SerializingProvider provider : this.providerList) {
            String[] formatIdentifiers;
            for (String formatIdentifier : formatIdentifiers = this.getFormatIdentifiers(provider)) {
                newProviderMap.put(formatIdentifier, provider);
            }
        }
        this.providerMap = newProviderMap;
    }

    private String[] getFormatIdentifiers(SerializingProvider SerializingProvider2) {
        Class<?> clazz = SerializingProvider2.getClass();
        SupportedFormat supportedFormatAnnotation = clazz.getAnnotation(SupportedFormat.class);
        String[] formatIdentifiers = supportedFormatAnnotation.value();
        return formatIdentifiers;
    }
}

