/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.wymiwyg.commons.util.collections.BidiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidiMapImpl<K, V>
implements BidiMap<K, V> {
    private final Map<K, V> forward;
    private final Map<V, K> backward;

    public BidiMapImpl() {
        this.forward = new HashMap();
        this.backward = new HashMap<V, K>();
    }

    private BidiMapImpl(Map<K, V> forward, Map<V, K> backward) {
        this.forward = forward;
        this.backward = backward;
    }

    @Override
    public K getKey(V value) {
        return this.backward.get(value);
    }

    @Override
    public int size() {
        return this.forward.size();
    }

    @Override
    public boolean isEmpty() {
        return this.forward.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.forward.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backward.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this.forward.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.backward.containsKey(value)) {
            K oldKey = this.backward.get(value);
            this.forward.remove(oldKey);
        }
        if (this.forward.containsKey(key)) {
            V oldValue = this.forward.get(key);
            this.backward.remove(oldValue);
        }
        this.backward.put(value, key);
        return this.forward.put(key, value);
    }

    @Override
    public V remove(Object key) {
        V value = this.forward.remove(key);
        this.backward.remove(value);
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.forward.clear();
        this.backward.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.forward.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.backward.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.forward.entrySet();
    }

    @Override
    public BidiMap<V, K> inverse() {
        return new BidiMapImpl<V, K>(this.backward, this.forward);
    }
}

