/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.xml.TimeUnitAdapter;
import org.apache.camel.model.OptionalIdentifiedDefinition;

@XmlRootElement(name="threadPoolProfile")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThreadPoolProfileDefinition
extends OptionalIdentifiedDefinition<ThreadPoolProfileDefinition> {
    @XmlAttribute
    private Boolean defaultProfile;
    @XmlAttribute
    private String poolSize;
    @XmlAttribute
    private String maxPoolSize;
    @XmlAttribute
    private String keepAliveTime;
    @XmlJavaTypeAdapter(value=TimeUnitAdapter.class)
    private TimeUnit timeUnit;
    @XmlAttribute
    private String maxQueueSize;
    @XmlAttribute
    private ThreadPoolRejectedPolicy rejectedPolicy;

    @Override
    public String getLabel() {
        return "ThreadPoolProfile " + this.getId();
    }

    public ThreadPoolProfileDefinition poolSize(int poolSize) {
        return this.poolSize("" + poolSize);
    }

    public ThreadPoolProfileDefinition poolSize(String poolSize) {
        this.setPoolSize(poolSize);
        return this;
    }

    public ThreadPoolProfileDefinition maxPoolSize(int maxPoolSize) {
        return this.maxPoolSize("" + this.maxQueueSize);
    }

    public ThreadPoolProfileDefinition maxPoolSize(String maxPoolSize) {
        this.setMaxPoolSize("" + maxPoolSize);
        return this;
    }

    public ThreadPoolProfileDefinition keepAliveTime(long keepAliveTime) {
        return this.keepAliveTime("" + keepAliveTime);
    }

    public ThreadPoolProfileDefinition keepAliveTime(String keepAliveTime) {
        this.setKeepAliveTime("" + keepAliveTime);
        return this;
    }

    public ThreadPoolProfileDefinition timeUnit(TimeUnit timeUnit) {
        this.setTimeUnit(timeUnit);
        return this;
    }

    public ThreadPoolProfileDefinition maxQueueSize(int maxQueueSize) {
        return this.maxQueueSize("" + maxQueueSize);
    }

    public ThreadPoolProfileDefinition maxQueueSize(String maxQueueSize) {
        this.setMaxQueueSize("" + maxQueueSize);
        return this;
    }

    public ThreadPoolProfileDefinition rejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.setRejectedPolicy(rejectedPolicy);
        return this;
    }

    public Boolean getDefaultProfile() {
        return this.defaultProfile;
    }

    public void setDefaultProfile(Boolean defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    public Boolean isDefaultProfile() {
        return this.defaultProfile != null && this.defaultProfile != false;
    }

    public String getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(String poolSize) {
        this.poolSize = poolSize;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(String keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public ThreadPoolRejectedPolicy getRejectedPolicy() {
        return this.rejectedPolicy;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        if (this.rejectedPolicy != null) {
            return this.rejectedPolicy.asRejectedExecutionHandler();
        }
        return null;
    }

    public void setRejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.rejectedPolicy = rejectedPolicy;
    }
}

