/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.List;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.AbstractIdentityContext;
import org.picketlink.idm.internal.PrivilegeChainQuery;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.StoreSelector;

public class ContextualRelationshipManager
extends AbstractIdentityContext
implements RelationshipManager {
    private StoreSelector storeSelector;
    private PrivilegeChainQuery privilegeChainQuery;

    public ContextualRelationshipManager(EventBridge eventBridge, IdGenerator idGenerator, StoreSelector storeSelector, PrivilegeChainQuery privilegeChainQuery) {
        super(null, eventBridge, idGenerator);
        this.storeSelector = storeSelector;
        this.privilegeChainQuery = privilegeChainQuery;
    }

    public void add(Relationship relationship) {
        if (relationship == null) {
            IDMInternalMessages.MESSAGES.nullArgument("Relationship");
        }
        try {
            this.storeSelector.getStoreForRelationshipOperation((IdentityContext)this, relationship.getClass(), relationship, IdentityStoreConfiguration.IdentityOperation.create).add((IdentityContext)this, (AttributedType)relationship);
            this.addAttributes(relationship);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.attributedTypeAddFailed((AttributedType)relationship, e);
        }
    }

    public void update(Relationship relationship) {
        if (relationship == null) {
            IDMInternalMessages.MESSAGES.nullArgument("Relationship");
        }
        try {
            this.storeSelector.getStoreForRelationshipOperation((IdentityContext)this, relationship.getClass(), relationship, IdentityStoreConfiguration.IdentityOperation.update).update((IdentityContext)this, (AttributedType)relationship);
            this.removeAttributes(relationship);
            this.addAttributes(relationship);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.attributedTypeUpdateFailed((AttributedType)relationship, e);
        }
    }

    public void remove(Relationship relationship) {
        if (relationship == null) {
            IDMInternalMessages.MESSAGES.nullArgument("Relationship");
        }
        try {
            List result = this.createRelationshipQuery(relationship.getClass()).setParameter(Relationship.ID, new Object[]{relationship.getId()}).getResultList();
            if (!result.isEmpty()) {
                this.removeAllAttributes(relationship);
            }
            this.storeSelector.getStoreForRelationshipOperation((IdentityContext)this, relationship.getClass(), relationship, IdentityStoreConfiguration.IdentityOperation.delete).remove((IdentityContext)this, (AttributedType)relationship);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.attributedTypeRemoveFailed((AttributedType)relationship, e);
        }
    }

    public <T extends Relationship> RelationshipQuery<T> createRelationshipQuery(Class<T> relationshipClass) {
        if (relationshipClass == null) {
            IDMInternalMessages.MESSAGES.nullArgument("Relationship Type");
        }
        return new DefaultRelationshipQuery<T>(this, relationshipClass, this.storeSelector);
    }

    private void removeAllAttributes(Relationship identityType) {
        Relationship storedType;
        AttributeStore attributeStore = this.storeSelector.getStoreForAttributeOperation((IdentityContext)this);
        if (attributeStore != null && (storedType = this.lookupById(identityType.getClass(), identityType.getId())) != null) {
            for (Attribute attribute : storedType.getAttributes()) {
                attributeStore.removeAttribute((IdentityContext)this, (AttributedType)identityType, attribute.getName());
            }
        }
    }

    private void addAttributes(Relationship identityType) {
        AttributeStore attributeStore = this.storeSelector.getStoreForAttributeOperation((IdentityContext)this);
        if (attributeStore != null) {
            for (Attribute attribute : identityType.getAttributes()) {
                attributeStore.setAttribute((IdentityContext)this, (AttributedType)identityType, attribute);
            }
        }
    }

    private void removeAttributes(Relationship identityType) {
        Relationship storedType;
        AttributeStore attributeStore = this.storeSelector.getStoreForAttributeOperation((IdentityContext)this);
        if (attributeStore != null && (storedType = this.lookupById(identityType.getClass(), identityType.getId())) != null) {
            for (Attribute attribute : storedType.getAttributes()) {
                if (identityType.getAttribute(attribute.getName()) != null) continue;
                attributeStore.removeAttribute((IdentityContext)this, (AttributedType)identityType, attribute.getName());
            }
        }
    }

    private Relationship lookupById(Class<? extends Relationship> relationshipType, String id) {
        List result = this.createRelationshipQuery(relationshipType).setParameter(Relationship.ID, new Object[]{id}).getResultList();
        if (!result.isEmpty()) {
            return (Relationship)result.get(0);
        }
        return null;
    }

    public boolean inheritsPrivileges(IdentityType identity, IdentityType assignee) {
        if (identity.equals(assignee)) {
            return true;
        }
        return this.privilegeChainQuery.inheritsPrivileges(this, identity, assignee);
    }
}

