/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal.mappers;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.jpa.annotations.OwnerReference;
import org.picketlink.idm.jpa.annotations.PermissionOperation;
import org.picketlink.idm.jpa.annotations.PermissionResourceClass;
import org.picketlink.idm.jpa.annotations.PermissionResourceIdentifier;
import org.picketlink.idm.jpa.annotations.entity.PermissionManaged;

public class PermissionEntityMapper {
    private Set<Class<?>> resourceClasses = new HashSet();
    private Class<?> entityClass;
    private Property<Object> owner;
    private Property<String> resourceClass;
    private Property<Serializable> resourceIdentifier;
    private Property<Object> operation;

    public PermissionEntityMapper(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.owner = PropertyQueries.createQuery(entityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(OwnerReference.class)).getSingleResult();
        this.resourceClass = PropertyQueries.createQuery(entityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(PermissionResourceClass.class)).getSingleResult();
        this.resourceIdentifier = PropertyQueries.createQuery(entityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(PermissionResourceIdentifier.class)).getSingleResult();
        this.operation = PropertyQueries.createQuery(entityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(PermissionOperation.class)).getSingleResult();
        PermissionManaged annotation = entityClass.getAnnotation(PermissionManaged.class);
        if (annotation.resourceClasses().length == 0) {
            this.resourceClasses.add(Object.class);
        } else {
            for (Class resourceClass : annotation.resourceClasses()) {
                this.resourceClasses.add(resourceClass);
            }
        }
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Set<Class<?>> getResourceClasses() {
        return this.resourceClasses;
    }

    public Property<Object> getOwner() {
        return this.owner;
    }

    public Property<String> getResourceClass() {
        return this.resourceClass;
    }

    public Property<Serializable> getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public Property<Object> getOperation() {
        return this.operation;
    }
}

