/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.spi.activation.ClassDeactivator;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassUtils;

@Typed
public abstract class ClassDeactivationUtils {
    private static final Logger LOG = Logger.getLogger(ClassDeactivationUtils.class.getName());
    private static Map<ClassLoader, List<ClassDeactivator>> classDeactivatorMap = new ConcurrentHashMap<ClassLoader, List<ClassDeactivator>>();
    private static Map<Class<? extends Deactivatable>, Boolean> activationStatusCache = new ConcurrentHashMap<Class<? extends Deactivatable>, Boolean>();

    private ClassDeactivationUtils() {
    }

    public static boolean isActivated(Class<? extends Deactivatable> targetClass) {
        Boolean activatedClassCacheEntry = activationStatusCache.get(targetClass);
        if (activatedClassCacheEntry == null) {
            ClassDeactivationUtils.initDeactivatableCacheFor(targetClass);
            activatedClassCacheEntry = activationStatusCache.get(targetClass);
        }
        return activatedClassCacheEntry;
    }

    private static synchronized void initDeactivatableCacheFor(Class<? extends Deactivatable> targetClass) {
        Boolean activatedClassCacheEntry = activationStatusCache.get(targetClass);
        if (activatedClassCacheEntry != null) {
            return;
        }
        List<ClassDeactivator> classDeactivators = ClassDeactivationUtils.getClassDeactivators();
        Boolean isActivated = Boolean.TRUE;
        Class<?> deactivatedBy = null;
        LOG.fine("start evaluation if " + targetClass.getName() + " is de-/activated");
        for (ClassDeactivator classDeactivator : classDeactivators) {
            Boolean isLocallyActivated = classDeactivator.isActivated(targetClass);
            if (isLocallyActivated == null) continue;
            isActivated = isLocallyActivated;
            if (!isActivated.booleanValue()) {
                deactivatedBy = classDeactivator.getClass();
                LOG.fine("Deactivating class " + targetClass);
                continue;
            }
            if (deactivatedBy == null) continue;
            LOG.fine("Reactivation of: " + targetClass.getName() + " by " + classDeactivator.getClass().getName() + " - original deactivated by: " + deactivatedBy.getName() + ".\n" + "If that isn't the intended behaviour, you have to use a higher ordinal for " + deactivatedBy.getName());
        }
        ClassDeactivationUtils.cacheResult(targetClass, isActivated);
    }

    private static void cacheResult(Class<? extends Deactivatable> targetClass, Boolean activated) {
        activationStatusCache.put(targetClass, activated);
        LOG.info("class: " + targetClass.getName() + " activated=" + activated);
    }

    private static List<ClassDeactivator> getClassDeactivators() {
        ClassLoader classLoader = ClassUtils.getClassLoader(null);
        List<ClassDeactivator> classDeactivators = classDeactivatorMap.get(classLoader);
        if (classDeactivators == null) {
            return ClassDeactivationUtils.initConfiguredClassDeactivators(classLoader);
        }
        return classDeactivators;
    }

    private static List<ClassDeactivator> initConfiguredClassDeactivators(ClassLoader classLoader) {
        List<String> classDeactivatorClassNames = ConfigResolver.getAllPropertyValues(ClassDeactivator.class.getName());
        ArrayList<ClassDeactivator> classDeactivators = new ArrayList<ClassDeactivator>();
        for (String classDeactivatorClassName : classDeactivatorClassNames) {
            LOG.fine("processing ClassDeactivator: " + classDeactivatorClassName);
            try {
                ClassDeactivator currentClassDeactivator = (ClassDeactivator)ClassUtils.instantiateClassForName(classDeactivatorClassName);
                classDeactivators.add(currentClassDeactivator);
            }
            catch (Exception e) {
                LOG.warning(classDeactivatorClassName + " can't be instantiated");
                throw new IllegalStateException(e);
            }
        }
        classDeactivatorMap.put(classLoader, classDeactivators);
        return classDeactivators;
    }
}

