/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.core.spi.config.ConfigSourceProvider;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ServiceUtils;

@Typed
public final class ConfigResolver {
    private static final Logger LOG = Logger.getLogger(ConfigResolver.class.getName());
    private static Map<ClassLoader, ConfigSource[]> configSources = new ConcurrentHashMap<ClassLoader, ConfigSource[]>();

    private ConfigResolver() {
    }

    public static synchronized void addConfigSources(List<ConfigSource> configSourcesToAdd) {
        ConfigResolver.getConfigSources();
        ClassLoader currentClassLoader = ClassUtils.getClassLoader(null);
        ConfigSource[] configuredConfigSources = configSources.get(currentClassLoader);
        ArrayList<ConfigSource> allConfigSources = new ArrayList<ConfigSource>();
        allConfigSources.addAll(Arrays.asList(configuredConfigSources));
        allConfigSources.addAll(configSourcesToAdd);
        configSources.put(currentClassLoader, ConfigResolver.sortDescending(allConfigSources));
    }

    public static synchronized void freeConfigSources() {
        configSources.remove(ClassUtils.getClassLoader(null));
    }

    public static String getPropertyValue(String key, String defaultValue) {
        String configuredValue = ConfigResolver.getPropertyValue(key);
        if (configuredValue == null) {
            LOG.log(Level.FINE, "no configured value found for key {0}, using default value {1}.", new Object[]{key, defaultValue});
            configuredValue = defaultValue;
        }
        return configuredValue;
    }

    public static String getPropertyValue(String key) {
        ConfigSource[] appConfigSources;
        for (ConfigSource configSource : appConfigSources = ConfigResolver.getConfigSources()) {
            String value = configSource.getPropertyValue(key);
            if (value != null) {
                LOG.log(Level.FINE, "found value {0} for key {1} in ConfigSource {2}.", new Object[]{value, key, configSource.getConfigName()});
                return value;
            }
            LOG.log(Level.FINER, "NO value found for key {0} in ConfigSource {1}.", new Object[]{key, configSource.getConfigName()});
        }
        return null;
    }

    public static List<String> getAllPropertyValues(String key) {
        List<ConfigSource> appConfigSources = ConfigResolver.sortAscending(new ArrayList<ConfigSource>(Arrays.asList(ConfigResolver.getConfigSources())));
        ArrayList<String> result = new ArrayList<String>();
        for (ConfigSource configSource : appConfigSources) {
            String value = configSource.getPropertyValue(key);
            if (value == null || result.contains(value)) continue;
            result.add(value);
        }
        return result;
    }

    public static Map<String, String> getAllProperties() {
        List<ConfigSource> appConfigSources = ConfigResolver.sortAscending(new ArrayList<ConfigSource>(Arrays.asList(ConfigResolver.getConfigSources())));
        HashMap<String, String> result = new HashMap<String, String>();
        for (ConfigSource configSource : appConfigSources) {
            if (!configSource.isScannable()) continue;
            result.putAll(configSource.getProperties());
        }
        return Collections.unmodifiableMap(result);
    }

    private static synchronized ConfigSource[] getConfigSources() {
        ClassLoader currentClassLoader = ClassUtils.getClassLoader(null);
        ConfigSource[] appConfigSources = configSources.get(currentClassLoader);
        if (appConfigSources == null) {
            appConfigSources = ConfigResolver.sortDescending(ConfigResolver.resolveConfigSources());
            if (LOG.isLoggable(Level.FINE)) {
                for (ConfigSource cs : appConfigSources) {
                    LOG.log(Level.FINE, "Adding ordinal {0} ConfigSource {1}", new Object[]{cs.getOrdinal(), cs.getConfigName()});
                }
            }
            configSources.put(currentClassLoader, appConfigSources);
        }
        return appConfigSources;
    }

    private static List<ConfigSource> resolveConfigSources() {
        List<ConfigSource> appConfigSources = ServiceUtils.loadServiceImplementations(ConfigSource.class);
        List<ConfigSourceProvider> configSourceProviderServiceLoader = ServiceUtils.loadServiceImplementations(ConfigSourceProvider.class);
        for (ConfigSourceProvider configSourceProvider : configSourceProviderServiceLoader) {
            appConfigSources.addAll(configSourceProvider.getConfigSources());
        }
        return appConfigSources;
    }

    private static ConfigSource[] sortDescending(List<ConfigSource> configSources) {
        Collections.sort(configSources, new Comparator<ConfigSource>(){

            @Override
            public int compare(ConfigSource configSource1, ConfigSource configSource2) {
                return configSource1.getOrdinal() > configSource2.getOrdinal() ? -1 : 1;
            }
        });
        return configSources.toArray(new ConfigSource[configSources.size()]);
    }

    private static List<ConfigSource> sortAscending(List<ConfigSource> configSources) {
        Collections.sort(configSources, new Comparator<ConfigSource>(){

            @Override
            public int compare(ConfigSource configSource1, ConfigSource configSource2) {
                return configSource1.getOrdinal() > configSource2.getOrdinal() ? 1 : -1;
            }
        });
        return configSources;
    }
}

