/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.htmlextractor.impl;

import java.net.URI;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleURIResolver
implements URIResolver {
    public static Bundle BUNDLE;
    private static final Logger LOG;

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        if (base == null) {
            LOG.error("No base given for: " + href);
            return null;
        }
        try {
            LOG.debug("base: " + base + "\n" + "href: " + href);
            if (base.startsWith("bundle:")) {
                URI baseURI = new URI(base);
                String path = baseURI.getPath();
                String resource = path.substring(1, path.lastIndexOf(47) + 1) + href;
                URL newUrl = BUNDLE.getEntry(resource);
                LOG.debug("Resource: " + resource);
                if (newUrl != null) {
                    return new StreamSource(newUrl.openStream(), newUrl.toString());
                }
                return null;
            }
            String resource = base.substring(0, base.lastIndexOf(47) + 1) + href;
            URL newUrl = new URL(resource);
            return new StreamSource(newUrl.openStream(), newUrl.toString());
        }
        catch (Exception ex) {
            throw new TransformerException("BundleURIResolver failed: " + ex.getMessage());
        }
    }

    static {
        LOG = LoggerFactory.getLogger(BundleURIResolver.class);
    }
}

