/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl;

import java.util.Collection;
import java.util.Iterator;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.impl.AbstractTripleCollection;
import org.apache.clerezza.rdf.core.impl.graphmatching.GraphMatcher;

public abstract class AbstractGraph
extends AbstractTripleCollection
implements Graph {
    @Override
    public final synchronized int hashCode() {
        int result = 0;
        Iterator<Triple> iter = this.iterator();
        while (iter.hasNext()) {
            result += this.getBlankNodeBlindHash(iter.next());
        }
        return result;
    }

    private int getBlankNodeBlindHash(Triple triple) {
        Resource object;
        int hash = triple.getPredicate().hashCode();
        NonLiteral subject = triple.getSubject();
        if (!(subject instanceof BNode)) {
            hash ^= subject.hashCode() >> 1;
        }
        if (!((object = triple.getObject()) instanceof BNode)) {
            hash ^= object.hashCode() << 1;
        }
        return hash;
    }

    @Override
    public boolean add(Triple e) {
        throw new UnsupportedOperationException("Graphs are not mutable, use MGraph");
    }

    @Override
    public boolean addAll(Collection<? extends Triple> c) {
        throw new UnsupportedOperationException("Graphs are not mutable, use MGraph");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Graphs are not mutable, use MGraph");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Graphs are not mutable, use MGraph");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Graphs are not mutable, use MGraph");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Graph)) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        return GraphMatcher.getValidMapping(this, (Graph)obj) != null;
    }
}

