/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.permission.acl.spi;

import java.io.Serializable;
import java.util.List;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.PermissionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.permission.IdentityPermission;
import org.picketlink.idm.permission.Permission;
import org.picketlink.idm.permission.spi.PermissionVoter;

public class PersistentPermissionVoter
implements PermissionVoter {
    private final PartitionManager partitionManager;

    public PersistentPermissionVoter(PartitionManager partitionManager) {
        this.partitionManager = partitionManager;
    }

    @Override
    public PermissionVoter.VotingResult hasPermission(IdentityType recipient, Object resource, String operation) {
        if (recipient == null) {
            throw new IllegalArgumentException("recipient must not be null");
        }
        PermissionVoter.VotingResult result = PermissionVoter.VotingResult.NOT_APPLICABLE;
        PermissionManager pm = this.partitionManager.createPermissionManager(recipient.getPartition());
        RelationshipManager rm = this.partitionManager.createRelationshipManager();
        List<Permission> permissions = pm.listPermissions(resource, operation);
        for (Permission permission : permissions) {
            if (!(permission instanceof IdentityPermission)) continue;
            IdentityPermission idPermission = (IdentityPermission)permission;
            if (recipient.equals(idPermission.getAssignee())) {
                result = PermissionVoter.VotingResult.ALLOW;
                break;
            }
            if (!rm.inheritsPrivileges(recipient, idPermission.getAssignee())) continue;
            result = PermissionVoter.VotingResult.ALLOW;
            break;
        }
        return result;
    }

    @Override
    public PermissionVoter.VotingResult hasPermission(IdentityType recipient, Class<?> resourceClass, Serializable identifier, String operation) {
        return null;
    }
}

