/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultPropertiesResolver
implements PropertiesResolver {
    @Override
    public Properties resolveProperties(CamelContext context, boolean ignoreMissingLocation, String ... uri) throws Exception {
        Properties answer = new Properties();
        for (String path : uri) {
            Properties prop;
            if (path.startsWith("ref:")) {
                prop = this.loadPropertiesFromRegistry(context, ignoreMissingLocation, path);
                prop = this.prepareLoadedProperties(prop);
                answer.putAll((Map<?, ?>)prop);
                continue;
            }
            if (path.startsWith("file:")) {
                prop = this.loadPropertiesFromFilePath(context, ignoreMissingLocation, path);
                prop = this.prepareLoadedProperties(prop);
                answer.putAll((Map<?, ?>)prop);
                continue;
            }
            prop = this.loadPropertiesFromClasspath(context, ignoreMissingLocation, path);
            prop = this.prepareLoadedProperties(prop);
            answer.putAll((Map<?, ?>)prop);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadPropertiesFromFilePath(CamelContext context, boolean ignoreMissingLocation, String path) throws IOException {
        Properties answer = new Properties();
        if (path.startsWith("file:")) {
            path = ObjectHelper.after(path, "file:");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(path);
            answer.load(is);
        }
        catch (FileNotFoundException e) {
            block5: {
                try {
                    if (ignoreMissingLocation) break block5;
                    throw e;
                }
                catch (Throwable throwable) {
                    IOHelper.close(is);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)is);
        }
        IOHelper.close((Closeable)is);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadPropertiesFromClasspath(CamelContext context, boolean ignoreMissingLocation, String path) throws IOException {
        InputStream is;
        Properties answer = new Properties();
        if (path.startsWith("classpath:")) {
            path = ObjectHelper.after(path, "classpath:");
        }
        if ((is = context.getClassResolver().loadResourceAsStream(path)) == null) {
            if (!ignoreMissingLocation) {
                throw new FileNotFoundException("Properties file " + path + " not found in classpath");
            }
        } else {
            try {
                answer.load(is);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
        return answer;
    }

    protected Properties loadPropertiesFromRegistry(CamelContext context, boolean ignoreMissingLocation, String path) throws IOException {
        if (path.startsWith("ref:")) {
            path = ObjectHelper.after(path, "ref:");
        }
        Properties answer = null;
        try {
            answer = context.getRegistry().lookupByNameAndType(path, Properties.class);
        }
        catch (Exception ex) {
            Map map = context.getRegistry().lookupByNameAndType(path, Map.class);
            answer = new Properties();
            answer.putAll((Map<?, ?>)map);
        }
        if (answer == null && !ignoreMissingLocation) {
            throw new FileNotFoundException("Properties " + path + " not found in registry");
        }
        return answer != null ? answer : new Properties();
    }

    protected Properties prepareLoadedProperties(Properties properties) {
        Properties answer = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String s = (String)value;
                value = DefaultPropertiesResolver.trimTrailingWhitespaces(s);
            }
            answer.put(key, value);
        }
        return answer;
    }

    private static String trimTrailingWhitespaces(String s) {
        int endIndex = s.length();
        int index = s.length() - 1;
        while (index >= 0 && s.charAt(index) == ' ') {
            endIndex = index--;
        }
        String answer = s.substring(0, endIndex);
        return answer;
    }
}

