/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.access;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.access.LockableMGraphWrapper;
import org.apache.clerezza.rdf.core.access.NoSuchEntityException;
import org.apache.clerezza.rdf.core.access.TcProvider;
import org.apache.clerezza.rdf.core.access.WeightedProviderComparator;
import org.apache.clerezza.rdf.core.access.WeightedTcProvider;

public class TcProviderMultiplexer
implements TcProvider {
    private SortedSet<WeightedTcProvider> providerList = new TreeSet<WeightedTcProvider>(new WeightedProviderComparator());
    private Map<UriRef, MGraphHolder> mGraphCache = Collections.synchronizedMap(new HashMap());

    public void addWeightedTcProvider(WeightedTcProvider provider) {
        this.providerList.add(provider);
        this.updateLockableMGraphCache(provider, true);
    }

    public void removeWeightedTcProvider(WeightedTcProvider provider) {
        this.providerList.remove(provider);
        this.updateLockableMGraphCache(provider, false);
    }

    protected void graphAppears(UriRef name) {
    }

    protected void mGraphAppears(UriRef name) {
    }

    protected void tcDisappears(UriRef name) {
    }

    private void updateLockableMGraphCache(WeightedTcProvider provider, boolean providerAdded) {
        Set<UriRef> uriSet = provider.listTripleCollections();
        if (uriSet != null && !uriSet.isEmpty()) {
            if (providerAdded) {
                this.weightedProviderAdded(provider, uriSet);
            } else {
                this.weightedProviderRemoved(provider, uriSet);
            }
        }
    }

    private void weightedProviderAdded(WeightedTcProvider newProvider, Set<UriRef> newProvidedUris) {
        Set<WeightedTcProvider> lowerWeightedProviderList = this.getLowerWeightedProvider(newProvider);
        for (UriRef name : newProvidedUris) {
            TripleCollection triples;
            MGraphHolder holder = this.mGraphCache.get(name);
            if (holder != null && holder.getWeightedTcProvider() != null) {
                if (!lowerWeightedProviderList.contains(holder.getWeightedTcProvider())) continue;
                this.tcDisappears(name);
                this.mGraphCache.remove(name);
            }
            if ((triples = newProvider.getTriples(name)) instanceof MGraph) {
                this.mGraphCache.put(name, new MGraphHolder(newProvider, this.ensureLockable((MGraph)triples)));
                this.mGraphAppears(name);
                continue;
            }
            this.graphAppears(name);
        }
    }

    private Set<WeightedTcProvider> getLowerWeightedProvider(WeightedTcProvider newProvider) {
        boolean referenceProviderPassed = false;
        HashSet<WeightedTcProvider> lowerWeightedProviderList = new HashSet<WeightedTcProvider>();
        for (WeightedTcProvider weightedProvider : this.providerList) {
            if (referenceProviderPassed) {
                lowerWeightedProviderList.add(weightedProvider);
                continue;
            }
            if (!newProvider.equals(weightedProvider)) continue;
            referenceProviderPassed = true;
        }
        return lowerWeightedProviderList;
    }

    private void weightedProviderRemoved(WeightedTcProvider oldProvider, Set<UriRef> oldProvidedUris) {
        block2: for (UriRef name : oldProvidedUris) {
            MGraphHolder holder = this.mGraphCache.get(name);
            if (holder == null || holder.getWeightedTcProvider() == null || !holder.getWeightedTcProvider().equals(oldProvider)) continue;
            this.tcDisappears(name);
            this.mGraphCache.remove(name);
            for (WeightedTcProvider provider : this.providerList) {
                try {
                    TripleCollection triples = provider.getTriples(name);
                    if (triples instanceof MGraph) {
                        this.mGraphCache.put(name, new MGraphHolder(provider, this.ensureLockable((MGraph)triples)));
                        this.mGraphAppears(name);
                        continue block2;
                    }
                    this.graphAppears(name);
                    continue block2;
                }
                catch (NoSuchEntityException e) {
                }
            }
        }
    }

    @Override
    public Graph getGraph(UriRef name) throws NoSuchEntityException {
        for (WeightedTcProvider provider : this.providerList) {
            try {
                return provider.getGraph(name);
            }
            catch (NoSuchEntityException e) {
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw new NoSuchEntityException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockableMGraph getMGraph(UriRef name) throws NoSuchEntityException {
        LockableMGraph result = this.getMGraphFromCache(name);
        if (result == null) {
            TcProviderMultiplexer tcProviderMultiplexer = this;
            synchronized (tcProviderMultiplexer) {
                result = this.getMGraphFromCache(name);
                if (result == null) {
                    result = this.getUnsecuredMGraphAndAddToCache(name);
                }
            }
        }
        return result;
    }

    private LockableMGraph getMGraphFromCache(UriRef name) {
        MGraphHolder holder = this.mGraphCache.get(name);
        if (holder == null) {
            return null;
        }
        return holder.getMGraph();
    }

    private LockableMGraph getUnsecuredMGraphAndAddToCache(UriRef name) throws NoSuchEntityException {
        for (WeightedTcProvider provider : this.providerList) {
            try {
                MGraph providedMGraph = provider.getMGraph(name);
                LockableMGraph result = this.ensureLockable(providedMGraph);
                MGraphHolder holder = this.mGraphCache.get(name);
                this.mGraphCache.put(name, new MGraphHolder(provider, result));
                return result;
            }
            catch (NoSuchEntityException e) {
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw new NoSuchEntityException(name);
    }

    @Override
    public TripleCollection getTriples(UriRef name) throws NoSuchEntityException {
        for (WeightedTcProvider provider : this.providerList) {
            try {
                TripleCollection result = provider.getTriples(name);
                if (!(result instanceof MGraph)) {
                    return result;
                }
                return this.getMGraph(name);
            }
            catch (NoSuchEntityException e) {
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw new NoSuchEntityException(name);
    }

    @Override
    public LockableMGraph createMGraph(UriRef name) throws UnsupportedOperationException {
        for (WeightedTcProvider provider : this.providerList) {
            try {
                MGraph providedMGraph = provider.createMGraph(name);
                LockableMGraph result = providedMGraph instanceof LockableMGraph ? (LockableMGraph)providedMGraph : new LockableMGraphWrapper(providedMGraph);
                this.tcDisappears(name);
                this.mGraphCache.put(name, new MGraphHolder(provider, null));
                this.mGraphAppears(name);
                return result;
            }
            catch (UnsupportedOperationException e) {
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw new UnsupportedOperationException("No provider could create MGraph.");
    }

    @Override
    public Graph createGraph(UriRef name, TripleCollection triples) {
        for (WeightedTcProvider provider : this.providerList) {
            try {
                Graph result = provider.createGraph(name, triples);
                this.tcDisappears(name);
                this.mGraphCache.put(name, new MGraphHolder(provider, null));
                this.graphAppears(name);
                return result;
            }
            catch (UnsupportedOperationException e) {
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw new UnsupportedOperationException("No provider could create Graph.");
    }

    @Override
    public void deleteTripleCollection(UriRef name) {
        for (WeightedTcProvider provider : this.providerList) {
            try {
                provider.deleteTripleCollection(name);
                MGraphHolder holder = this.mGraphCache.get(name);
                if (holder != null && holder.getWeightedTcProvider() != null && holder.getWeightedTcProvider().equals(provider)) {
                    this.tcDisappears(name);
                    this.mGraphCache.remove(name);
                }
                return;
            }
            catch (UnsupportedOperationException e) {
            }
            catch (NoSuchEntityException e) {
            }
            catch (IllegalArgumentException e) {
            }
        }
        this.getTriples(name);
        throw new UnsupportedOperationException("No provider could delete the entity.");
    }

    @Override
    public Set<UriRef> getNames(Graph graph) {
        HashSet<UriRef> result = new HashSet<UriRef>();
        for (WeightedTcProvider provider : this.providerList) {
            result.addAll(provider.getNames(graph));
        }
        return result;
    }

    @Override
    public Set<UriRef> listGraphs() {
        HashSet<UriRef> result = new HashSet<UriRef>();
        for (WeightedTcProvider provider : this.providerList) {
            result.addAll(provider.listGraphs());
        }
        return result;
    }

    @Override
    public Set<UriRef> listMGraphs() {
        HashSet<UriRef> result = new HashSet<UriRef>();
        for (WeightedTcProvider provider : this.providerList) {
            result.addAll(provider.listMGraphs());
        }
        return result;
    }

    @Override
    public Set<UriRef> listTripleCollections() {
        HashSet<UriRef> result = new HashSet<UriRef>();
        for (WeightedTcProvider provider : this.providerList) {
            result.addAll(provider.listTripleCollections());
        }
        return result;
    }

    private LockableMGraph ensureLockable(MGraph providedMGraph) {
        LockableMGraph result = providedMGraph instanceof LockableMGraph ? (LockableMGraph)providedMGraph : new LockableMGraphWrapper(providedMGraph);
        return result;
    }

    public SortedSet<WeightedTcProvider> getProviderList() {
        return this.providerList;
    }

    private static class MGraphHolder {
        private WeightedTcProvider tcProvider;
        private WeakReference<LockableMGraph> mGraphReference;

        MGraphHolder(WeightedTcProvider tcProvider, LockableMGraph mGraph) {
            this.tcProvider = tcProvider;
            this.mGraphReference = new WeakReference<LockableMGraph>(mGraph);
        }

        LockableMGraph getMGraph() {
            return (LockableMGraph)this.mGraphReference.get();
        }

        WeightedTcProvider getWeightedTcProvider() {
            return this.tcProvider;
        }
    }
}

