/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;

public class CLMLogFileAppender
extends FileAppender {
    public CLMLogFileAppender() {
    }

    public CLMLogFileAppender(Layout layout, String filename, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super(layout, filename, append, bufferedIO, bufferSize);
    }

    public CLMLogFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public CLMLogFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    public void activateOptions() {
        if (this.fileName != null) {
            try {
                this.fileName = this.getNewLogFileName();
                this.setFile(this.fileName, this.fileAppend, this.bufferedIO, this.bufferSize);
            }
            catch (Exception e) {
                this.errorHandler.error("Error while activating log options", e, 4);
            }
        }
    }

    private String getNewLogFileName() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
        String time = sdf.format(cal.getTime());
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StackTraceElement main = stack[stack.length - 1];
        String mainClass = main.getClassName();
        return System.getProperty("user.home") + "/EspressoLogs/" + mainClass + "_" + time + ".txt";
    }
}

