/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.util.Encode;

public class PathSegmentImpl
implements PathSegment {
    private String path;
    private String original;
    private MultivaluedMap<String, String> matrixParameters = new MultivaluedMapImpl<String, String>();

    public PathSegmentImpl(String segment, boolean decode) {
        this.original = segment;
        this.path = segment;
        int semicolon = segment.indexOf(59);
        if (semicolon >= 0) {
            String[] params;
            this.path = semicolon > 0 ? segment.substring(0, semicolon) : "";
            String matrixParams = segment.substring(semicolon + 1);
            for (String param : params = matrixParams.split(";")) {
                String[] namevalue = param.split("=");
                if (namevalue == null || namevalue.length <= 0) continue;
                String name = namevalue[0];
                if (decode) {
                    name = Encode.decodePath(name);
                }
                String value = "";
                if (namevalue.length > 1) {
                    value = namevalue[1];
                }
                if (decode) {
                    value = Encode.decodePath(value);
                }
                this.matrixParameters.add((Object)name, (Object)value);
            }
        }
        if (decode) {
            this.path = Encode.decodePath(this.path);
        }
    }

    public String getOriginal() {
        return this.original;
    }

    public String getPath() {
        return this.path;
    }

    public MultivaluedMap<String, String> getMatrixParameters() {
        return this.matrixParameters;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.path != null) {
            buf.append(this.path);
        }
        if (this.matrixParameters != null) {
            for (String name : this.matrixParameters.keySet()) {
                for (String value : (List)this.matrixParameters.get((Object)name)) {
                    buf.append(";").append(name).append("=").append(value);
                }
            }
        }
        return buf.toString();
    }

    public static List<PathSegment> parseSegments(String path, boolean decode) {
        String[] paths;
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        for (String p : paths = path.split("/")) {
            pathSegments.add(new PathSegmentImpl(p, decode));
        }
        return pathSegments;
    }
}

