/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.Buffer;
import org.restlet.engine.io.BufferState;
import org.restlet.engine.io.ChunkState;
import org.restlet.engine.io.CompletionListener;
import org.restlet.engine.io.ReadableBufferedChannel;
import org.restlet.engine.io.ReadableSelectionChannel;
import org.restlet.engine.io.WakeupListener;

public class ReadableChunkedChannel
extends ReadableBufferedChannel {
    private volatile ChunkState chunkState;
    private final StringBuilder lineBuilder;
    private volatile BufferState lineBuilderState;
    private volatile int remainingChunkSize;

    public ReadableChunkedChannel(CompletionListener completionListener, Buffer buffer, ReadableSelectionChannel source, WakeupListener wakeupListener) {
        super(completionListener, buffer, source, wakeupListener);
        if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
            Context.getCurrentLogger().log(Level.FINER, "ReadableChunkedChannel created from: " + source + ". Registration: " + this.getRegistration());
        }
        this.remainingChunkSize = 0;
        this.chunkState = ChunkState.SIZE;
        this.lineBuilder = new StringBuilder();
        this.lineBuilderState = BufferState.IDLE;
    }

    protected void clearLineBuilder() {
        this.getLineBuilder().delete(0, this.getLineBuilder().length());
        this.setLineBuilderState(BufferState.IDLE);
    }

    protected ChunkState getChunkState() {
        return this.chunkState;
    }

    protected StringBuilder getLineBuilder() {
        return this.lineBuilder;
    }

    protected BufferState getLineBuilderState() {
        return this.lineBuilderState;
    }

    protected int getRemainingChunkSize() {
        return this.remainingChunkSize;
    }

    /*
     * Unable to fully structure code
     */
    public int onDrain(Buffer buffer, int maxDrained, Object ... args) throws IOException {
        result = 0;
        targetBuffer = (ByteBuffer)args[0];
        doLoop = true;
        while (doLoop) {
            if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                Context.getCurrentLogger().log(Level.FINER, "Readable chunk state: " + (Object)this.getChunkState());
            }
            switch (1.$SwitchMap$org$restlet$engine$io$ChunkState[this.getChunkState().ordinal()]) {
                case 1: {
                    this.setLineBuilderState(buffer.drain(this.getLineBuilder(), this.getLineBuilderState()));
                    if (this.getLineBuilderState() != BufferState.DRAINING) ** GOTO lbl31
                    length = this.getLineBuilder().length();
                    if (length == 0) {
                        throw new IOException("An empty chunk size line was detected");
                    }
                    index = this.getLineBuilder().indexOf(";");
                    index = index == -1 ? this.getLineBuilder().length() : index;
                    try {
                        this.setRemainingChunkSize(Integer.parseInt(this.getLineBuilder().substring(0, index).trim(), 16));
                        if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                            Context.getCurrentLogger().log(Level.FINER, "New readable chunk detected. Size: " + this.remainingChunkSize);
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException("\"" + this.getLineBuilder() + "\" has an invalid chunk size");
                    }
                    finally {
                        this.clearLineBuilder();
                    }
                    if (this.getRemainingChunkSize() == 0) {
                        this.setChunkState(ChunkState.TRAILER);
                        break;
                    }
                    this.setChunkState(ChunkState.DATA);
                    break;
lbl31:
                    // 1 sources

                    doLoop = false;
                    break;
                }
                case 2: {
                    read = 0;
                    if (this.getRemainingChunkSize() > 0) {
                        read = super.onDrain(buffer, this.remainingChunkSize, new Object[]{targetBuffer});
                        result += read;
                        if (read > 0) {
                            this.setRemainingChunkSize(this.getRemainingChunkSize() - read);
                        } else if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
                            Context.getCurrentLogger().finer("No readable chunk data found");
                        }
                    }
                    if (this.getRemainingChunkSize() == 0) {
                        this.setLineBuilderState(buffer.drain(this.getLineBuilder(), this.getLineBuilderState()));
                        if (this.getLineBuilderState() == BufferState.DRAINING) {
                            this.setChunkState(ChunkState.SIZE);
                            this.clearLineBuilder();
                            break;
                        }
                        doLoop = false;
                        break;
                    }
                    doLoop = false;
                    break;
                }
                case 3: {
                    this.setChunkState(ChunkState.END);
                    break;
                }
                case 4: {
                    this.setLineBuilderState(buffer.drain(this.getLineBuilder(), this.getLineBuilderState()));
                    if (this.getLineBuilderState() == BufferState.DRAINING) {
                        if (this.getLineBuilder().length() != 0) {
                            Context.getCurrentLogger().log(Level.FINE, "The last readable chunk line had a non empty line");
                        }
                        this.setEndReached(true);
                        if (result <= 0) {
                            result = -1;
                        }
                        doLoop = false;
                        break;
                    }
                    doLoop = false;
                }
            }
        }
        return result;
    }

    protected void setChunkState(ChunkState chunkState) {
        this.chunkState = chunkState;
    }

    protected void setLineBuilderState(BufferState lineBuilderState) {
        this.lineBuilderState = lineBuilderState;
    }

    protected void setRemainingChunkSize(int remainingChunkSize) {
        this.remainingChunkSize = remainingChunkSize;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$restlet$engine$io$ChunkState;

        static {
            $SwitchMap$org$restlet$engine$io$ChunkState = new int[ChunkState.values().length];
            try {
                1.$SwitchMap$org$restlet$engine$io$ChunkState[ChunkState.SIZE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$restlet$engine$io$ChunkState[ChunkState.DATA.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$restlet$engine$io$ChunkState[ChunkState.TRAILER.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$restlet$engine$io$ChunkState[ChunkState.END.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

