/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.arguments;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.wymiwyg.commons.util.arguments.ArgumentHandler;
import org.wymiwyg.commons.util.arguments.ArgumentProcessor;
import org.wymiwyg.commons.util.arguments.CommandLine;
import org.wymiwyg.commons.util.arguments.InvalidArgumentsException;
import org.wymiwyg.commons.util.arguments.MissingArgumentException;
import org.wymiwyg.commons.util.arguments.NamedAttributeProcessor;
import org.wymiwyg.commons.util.arguments.PushBackIterator;
import org.wymiwyg.commons.util.arguments.SingleNamedAttributeProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedInterfaceArguments<T>
implements ArgumentProcessor {
    private Class<T> annotated;
    private Map<Method, Object> valueMap = new HashMap<Method, Object>();

    public static <U> AnnotatedInterfaceArguments<U> getInstance(Class<U> annotated, ArgumentHandler argumentHandler) throws InvalidArgumentsException {
        return new AnnotatedInterfaceArguments<U>(annotated, argumentHandler);
    }

    public static <U> U getValueObject(Class<U> annotated, ArgumentHandler argumentHandler) throws InvalidArgumentsException {
        return new AnnotatedInterfaceArguments<U>(annotated, argumentHandler).getValueObject();
    }

    private AnnotatedInterfaceArguments(Class<T> annotated, ArgumentHandler argumentHandler) throws InvalidArgumentsException {
        this.annotated = annotated;
        argumentHandler.processArguments(this);
    }

    public void process(List argumentList) throws InvalidArgumentsException {
        HashSet<Method> requiredArguments = new HashSet<Method>();
        NamedAttributeProcessor namedAttributeProcessor = new NamedAttributeProcessor();
        for (Method m : this.annotated.getMethods()) {
            if (!m.isAnnotationPresent(CommandLine.class)) continue;
            CommandLine cl = m.getAnnotation(CommandLine.class);
            if (cl.required()) {
                requiredArguments.add(m);
            }
            for (String longName : cl.longName()) {
                namedAttributeProcessor.addLongNameAttributeProcessor(new MySingleNamedAttributeProcessor(longName, cl, m));
            }
            for (String shortName : cl.shortName()) {
                namedAttributeProcessor.addNamedAttributeProcessor(new MySingleNamedAttributeProcessor(shortName, cl, m));
            }
        }
        HashSet<CommandLine> missingArguments = new HashSet<CommandLine>();
        namedAttributeProcessor.process(argumentList);
        for (Method current : requiredArguments) {
            if (this.valueMap.containsKey(current)) continue;
            missingArguments.add(current.getAnnotation(CommandLine.class));
        }
        if (missingArguments.size() > 0) {
            throw new MissingArgumentException(missingArguments);
        }
    }

    public T getValueObject() {
        Class[] interfaces = new Class[]{this.annotated};
        Object result = Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)new AnnotatedInterfaceProxy());
        return (T)result;
    }

    public static String getArgumentsSyntax(Class annotated) {
        StringWriter writer = new StringWriter();
        for (Method m : annotated.getMethods()) {
            if (!m.isAnnotationPresent(CommandLine.class)) continue;
            try {
                AnnotatedInterfaceArguments.printArgument(m, writer);
            }
            catch (IOException e) {
                throw new RuntimeException("never happens");
            }
        }
        return writer.toString();
    }

    private static void printArgument(Method method, Writer writer) throws IOException {
        CommandLine cl = method.getAnnotation(CommandLine.class);
        if (!cl.required()) {
            writer.write(91);
        }
        AnnotatedInterfaceArguments.printArgumentSyntax(cl, method, writer);
        if (!cl.required()) {
            writer.write(93);
        }
        writer.write(32);
    }

    private static void printValueRange(CommandLine cl, Method method, Writer writer) throws IOException {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Boolean.TYPE)) {
            if (!cl.isSwitch()) {
                writer.write(" {true|false}");
            }
        } else if (returnType.equals(File.class)) {
            writer.write(" filename");
        } else {
            writer.write(" string");
        }
    }

    private static void printNames(CommandLine cl, Writer writer) throws IOException {
        String name;
        int i;
        boolean first = true;
        for (i = 0; i < cl.shortName().length; ++i) {
            name = cl.shortName()[i];
            if (!first) {
                writer.write(124);
            } else {
                first = false;
            }
            writer.write("-");
            writer.write(name);
        }
        for (i = 0; i < cl.longName().length; ++i) {
            name = cl.longName()[i];
            if (!first) {
                writer.write(124);
            } else {
                first = false;
            }
            writer.write("--");
            writer.write(name);
        }
    }

    public static void printArgumentDescriptions(Class annotated, PrintWriter writer) {
        int maxLength = 0;
        for (Method m : annotated.getMethods()) {
            if (!m.isAnnotationPresent(CommandLine.class)) continue;
            int currentLength = AnnotatedInterfaceArguments.getArgumentSyntaxLength(m);
            maxLength = maxLength < currentLength ? currentLength : maxLength;
        }
        for (Method m : annotated.getMethods()) {
            if (!m.isAnnotationPresent(CommandLine.class)) continue;
            try {
                AnnotatedInterfaceArguments.printArgumentDescription(m, writer, maxLength);
            }
            catch (IOException e) {
                throw new RuntimeException("never happens");
            }
        }
    }

    private static int getArgumentSyntaxLength(Method m) {
        CommandLine cl = m.getAnnotation(CommandLine.class);
        return AnnotatedInterfaceArguments.getArgumentSyntax(cl, m).length();
    }

    private static String getArgumentSyntax(CommandLine cl, Method m) {
        StringWriter w = new StringWriter();
        try {
            AnnotatedInterfaceArguments.printArgumentSyntax(cl, m, w);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return w.toString();
    }

    private static void printArgumentDescription(Method method, PrintWriter writer, int maxLength) throws IOException {
        CommandLine cl = method.getAnnotation(CommandLine.class);
        writer.print("  ");
        String argumentSyntax = AnnotatedInterfaceArguments.getArgumentSyntax(cl, method);
        writer.print(argumentSyntax);
        for (int i = argumentSyntax.length(); i < maxLength + 3; ++i) {
            writer.print(' ');
        }
        writer.println(cl.description());
    }

    private static void printArgumentSyntax(CommandLine cl, Method method, Writer writer) throws IOException {
        AnnotatedInterfaceArguments.printNames(cl, writer);
        AnnotatedInterfaceArguments.printValueRange(cl, method, writer);
    }

    public static void showHelp(Class<?> type) {
        System.out.println("Usage: ");
        System.out.print("SmartHello ");
        System.out.println(AnnotatedInterfaceArguments.getArgumentsSyntax(type));
        PrintWriter out = new PrintWriter(System.out, true);
        AnnotatedInterfaceArguments.printArgumentDescriptions(type, out);
        out.flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AnnotatedInterfaceProxy
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value = AnnotatedInterfaceArguments.this.valueMap.get(method);
            Class<?> returnType = method.getReturnType();
            if (value == null) {
                CommandLine annotation = method.getAnnotation(CommandLine.class);
                if (returnType.equals(Boolean.TYPE)) {
                    if (annotation.isSwitch()) {
                        return Boolean.FALSE;
                    }
                    return annotation.defaultBooleanValue();
                }
                String[] defaultValues = annotation.defaultValue();
                if (returnType.isArray()) {
                    return defaultValues;
                }
                if (defaultValues.length > 0) {
                    return this.getObjectFromString(defaultValues[0], returnType);
                }
                return null;
            }
            if (returnType.isArray()) {
                String[] valueStrings = (String[])value;
                Object[] result = (Object[])Array.newInstance(returnType.getComponentType(), valueStrings.length);
                for (int i = 0; i < valueStrings.length; ++i) {
                    result[i] = this.getObjectFromString(valueStrings[i], returnType.getComponentType());
                }
                return result;
            }
            if (value.getClass().equals(String.class)) {
                return this.getObjectFromString((String)value, returnType);
            }
            return value;
        }

        private Object getObjectFromString(String string, Class<?> type) throws Exception {
            if (type.isPrimitive()) {
                type = this.civilize(type);
            }
            Class[] argTypes = new Class[]{String.class};
            Constructor<?> constructor = type.getConstructor(argTypes);
            Object[] argValues = new Object[]{string};
            Object result = constructor.newInstance(argValues);
            return result;
        }

        private Class<?> civilize(Class<?> primitive) {
            if (primitive.equals(Integer.TYPE)) {
                return Integer.class;
            }
            throw new RuntimeException("Civilization failed");
        }
    }

    private final class MySingleNamedAttributeProcessor
    extends SingleNamedAttributeProcessor {
        private final CommandLine cl;
        private final Method m;
        private final String name;

        private MySingleNamedAttributeProcessor(String name, CommandLine cl, Method m) {
            super(name);
            this.cl = cl;
            this.m = m;
            this.name = name;
        }

        public void process(PushBackIterator nextArguments) throws InvalidArgumentsException {
            Class<?> returnType = this.m.getReturnType();
            if (returnType.isArray()) {
                ArrayList<String> values = new ArrayList<String>();
                if (!nextArguments.hasNext()) {
                    throw new InvalidArgumentsException(this.name + "  must have at least one value");
                }
                values.add((String)nextArguments.next());
                while (nextArguments.hasNext()) {
                    String nextValue = (String)nextArguments.next();
                    if (!nextValue.startsWith("-")) continue;
                    nextArguments.pushBack(nextValue);
                    break;
                }
                AnnotatedInterfaceArguments.this.valueMap.put(this.m, values.toArray(new String[values.size()]));
            } else if (returnType.equals(Boolean.TYPE)) {
                if (this.cl.isSwitch()) {
                    AnnotatedInterfaceArguments.this.valueMap.put(this.m, Boolean.TRUE);
                } else {
                    boolean booleanValue;
                    if (!nextArguments.hasNext()) {
                        throw new InvalidArgumentsException(this.name + "  must have value true|yes or false|no");
                    }
                    String value = (String)nextArguments.next();
                    if (value.equals("true") || value.equals("yes")) {
                        booleanValue = true;
                    } else if (value.equals("false") || value.equals("no")) {
                        booleanValue = false;
                    } else {
                        throw new InvalidArgumentsException(this.name + "  must have value true|yes or false|no");
                    }
                    AnnotatedInterfaceArguments.this.valueMap.put(this.m, booleanValue);
                }
            } else {
                if (!nextArguments.hasNext()) {
                    throw new InvalidArgumentsException(this.name + "  must have a value");
                }
                AnnotatedInterfaceArguments.this.valueMap.put(this.m, nextArguments.next());
            }
        }
    }
}

