/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.binding;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.binding.BindingEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Binding;
import org.apache.camel.util.CamelContextHelper;

public class BindingNameComponent
extends DefaultComponent {
    protected static final String BAD_FORMAT_MESSAGE = "URI should be of the format binding:nameOfBinding:endpointURI";

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CamelContext camelContext = this.getCamelContext();
        int idx = remaining.indexOf(":");
        if (idx <= 0) {
            throw new IllegalArgumentException(BAD_FORMAT_MESSAGE);
        }
        String bindingName = remaining.substring(0, idx);
        String delegateURI = remaining.substring(idx + 1);
        if (delegateURI.isEmpty()) {
            throw new IllegalArgumentException(BAD_FORMAT_MESSAGE);
        }
        Binding binding = CamelContextHelper.mandatoryLookup(camelContext, bindingName, Binding.class);
        Endpoint delegate = CamelContextHelper.getMandatoryEndpoint(camelContext, delegateURI);
        return new BindingEndpoint(uri, this, binding, delegate);
    }
}

