/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultUnitOfWork;
import org.apache.camel.impl.MDCUnitOfWork;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.OrderedComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnitOfWorkHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UnitOfWorkHelper.class);

    private UnitOfWorkHelper() {
    }

    public static UnitOfWork createUoW(Exchange exchange) {
        DefaultUnitOfWork answer = exchange.getContext().isUseMDCLogging() != false ? new MDCUnitOfWork(exchange) : new DefaultUnitOfWork(exchange);
        return answer;
    }

    public static void doneUow(UnitOfWork uow, Exchange exchange) {
        try {
            if (uow != null) {
                uow.done(exchange);
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred during done UnitOfWork for Exchange: " + exchange + ". This exception will be ignored.", e);
        }
        try {
            if (uow != null) {
                uow.stop();
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred during stopping UnitOfWork for Exchange: " + exchange + ". This exception will be ignored.", e);
        }
        exchange.setUnitOfWork(null);
    }

    public static void doneSynchronizations(Exchange exchange, List<Synchronization> synchronizations, Logger log) {
        boolean failed = exchange.isFailed();
        if (synchronizations != null && !synchronizations.isEmpty()) {
            ArrayList<Synchronization> copy = new ArrayList<Synchronization>(synchronizations);
            Collections.reverse(copy);
            Collections.sort(copy, new OrderedComparator());
            for (Synchronization synchronization : copy) {
                try {
                    if (failed) {
                        log.trace("Invoking synchronization.onFailure: {} with {}", (Object)synchronization, (Object)exchange);
                        synchronization.onFailure(exchange);
                        continue;
                    }
                    log.trace("Invoking synchronization.onComplete: {} with {}", (Object)synchronization, (Object)exchange);
                    synchronization.onComplete(exchange);
                }
                catch (Throwable e) {
                    log.warn("Exception occurred during onCompletion. This exception will be ignored.", e);
                }
            }
        }
    }
}

