/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.util.StringTokenizer;
import org.apache.helix.healthcheck.AccumulateAggregationType;
import org.apache.helix.healthcheck.AggregationType;
import org.apache.helix.healthcheck.DecayAggregationType;
import org.apache.helix.healthcheck.WindowAggregationType;
import org.apache.log4j.Logger;

public class AggregationTypeFactory {
    private static final Logger logger = Logger.getLogger(AggregationTypeFactory.class);

    public static AggregationType getAggregationType(String input) {
        if (input == null) {
            logger.error((Object)"AggregationType name is null");
            return null;
        }
        StringTokenizer tok = new StringTokenizer(input, "#");
        String type = tok.nextToken();
        int numParams = tok.countTokens();
        String[] params = new String[numParams];
        for (int i = 0; i < numParams; ++i) {
            if (!tok.hasMoreTokens()) {
                logger.error((Object)"Trying to parse non-existent params");
                return null;
            }
            params[i] = tok.nextToken();
        }
        if (type.equals("accumulate")) {
            return new AccumulateAggregationType();
        }
        if (type.equals("decay")) {
            if (params.length < 1) {
                logger.error((Object)"DecayAggregationType must contain <decay weight> parameter");
                return null;
            }
            return new DecayAggregationType(Double.parseDouble(params[0]));
        }
        if (type.equals("window")) {
            if (params.length < 1) {
                logger.error((Object)"WindowAggregationType must contain <window size> parameter");
            }
            return new WindowAggregationType(Integer.parseInt(params[0]));
        }
        logger.error((Object)("Unknown AggregationType " + type));
        return null;
    }
}

