/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.Language;
import org.apache.clerezza.rdf.core.Literal;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.clerezza.rdf.core.impl.TypedLiteralImpl;
import org.apache.clerezza.rdf.core.sparql.JavaCCGeneratedQueryParserConstants;
import org.apache.clerezza.rdf.core.sparql.JavaCCGeneratedQueryParserTokenManager;
import org.apache.clerezza.rdf.core.sparql.ParseException;
import org.apache.clerezza.rdf.core.sparql.SimpleCharStream;
import org.apache.clerezza.rdf.core.sparql.Token;
import org.apache.clerezza.rdf.core.sparql.query.BinaryOperation;
import org.apache.clerezza.rdf.core.sparql.query.BuiltInCall;
import org.apache.clerezza.rdf.core.sparql.query.Expression;
import org.apache.clerezza.rdf.core.sparql.query.FunctionCall;
import org.apache.clerezza.rdf.core.sparql.query.GroupGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.LiteralExpression;
import org.apache.clerezza.rdf.core.sparql.query.Query;
import org.apache.clerezza.rdf.core.sparql.query.ResourceOrVariable;
import org.apache.clerezza.rdf.core.sparql.query.TriplePattern;
import org.apache.clerezza.rdf.core.sparql.query.UnaryOperation;
import org.apache.clerezza.rdf.core.sparql.query.UriRefExpression;
import org.apache.clerezza.rdf.core.sparql.query.UriRefOrVariable;
import org.apache.clerezza.rdf.core.sparql.query.Variable;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleAlternativeGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleAskQuery;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleConstructQuery;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleDescribeQuery;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleGraphGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleGroupGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleOrderCondition;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleQuery;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleQueryWithSolutionModifier;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleSelectQuery;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleTriplePattern;

class JavaCCGeneratedQueryParser
implements JavaCCGeneratedQueryParserConstants {
    private static final UriRef RDF_TYPE = new UriRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    private static final UriRef RDF_FIRST = new UriRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
    private static final UriRef RDF_REST = new UriRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
    private static final UriRef RDF_NIL = new UriRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
    private static final Pattern pfxNamePattern = Pattern.compile("([^:]*):(.*)");
    private Query query;
    private String base;
    private Map<String, String> prefixes;
    private Map<String, ResourceOrVariable> bNodes;
    private int count;
    private Map<String, Variable> vars;
    public JavaCCGeneratedQueryParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[77];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;

    void initialize() {
        this.query = null;
        this.base = null;
        this.prefixes = new HashMap<String, String>();
        this.bNodes = new HashMap<String, ResourceOrVariable>();
        this.count = 0;
        this.vars = new HashMap<String, Variable>();
    }

    Query parse() throws ParseException {
        this.initialize();
        this.Query();
        return this.query;
    }

    private static String unquote(String s) {
        return s.substring(1, s.length() - 1);
    }

    private static String unTripleQuote(String s) {
        return s.substring(3, s.length() - 3);
    }

    private Variable getVariable(String name) {
        Variable v = this.vars.get(name = name.substring(1));
        if (v == null) {
            SimpleDescribeQuery dq;
            v = new Variable(name);
            this.vars.put(name, v);
            if (this.query instanceof SimpleSelectQuery) {
                SimpleSelectQuery sq = (SimpleSelectQuery)this.query;
                if (sq.isSelectAll()) {
                    sq.addSelection(v);
                }
            } else if (this.query instanceof SimpleDescribeQuery && (dq = (SimpleDescribeQuery)this.query).isDescribeAll()) {
                dq.addResourceToDescribe(new ResourceOrVariable(v));
            }
        }
        return v;
    }

    private void addTriplePatterns(Set<TriplePattern> triplePatterns, ResourceOrVariable subject, UriRefOrVariable predicate, Set<ResourceOrVariable> objects) {
        for (ResourceOrVariable object : objects) {
            triplePatterns.add(new SimpleTriplePattern(subject, predicate, object));
        }
    }

    private ResourceOrVariable addTriplePatterns(Set<TriplePattern> triplePatterns, List<ResourceOrVariable> nodes) {
        ResourceOrVariable head = null;
        UriRefOrVariable rdfFirst = new UriRefOrVariable(RDF_FIRST);
        UriRefOrVariable rdfRest = new UriRefOrVariable(RDF_REST);
        UriRefOrVariable rdfNil = new UriRefOrVariable(RDF_NIL);
        ResourceOrVariable prevSubject = null;
        for (ResourceOrVariable node : nodes) {
            ResourceOrVariable currentSubject = this.getNewBNode();
            if (prevSubject != null) {
                triplePatterns.add(new SimpleTriplePattern(prevSubject, rdfRest, currentSubject));
            } else {
                head = currentSubject;
            }
            triplePatterns.add(new SimpleTriplePattern(currentSubject, rdfFirst, node));
            prevSubject = currentSubject;
        }
        if (prevSubject != null) {
            triplePatterns.add(new SimpleTriplePattern(prevSubject, rdfRest, rdfNil));
        }
        return head;
    }

    private ResourceOrVariable getNewBNode() {
        ResourceOrVariable bNode = new ResourceOrVariable(new BNode());
        this.bNodes.put("*" + this.count++, bNode);
        return bNode;
    }

    private ResourceOrVariable getBNode(String label) {
        ResourceOrVariable bNode = this.bNodes.get(label);
        if (bNode == null) {
            bNode = new ResourceOrVariable(new BNode());
            this.bNodes.put(label, bNode);
        }
        return bNode;
    }

    private UriRef createUriRef(String r) throws ParseException {
        Matcher m = pfxNamePattern.matcher(r);
        if (!m.matches()) {
            return JavaCCGeneratedQueryParser.isRelative(r) ? new UriRef(this.base + r) : new UriRef(r);
        }
        String ns = this.prefixes.get(m.group(1));
        return ns == null ? new UriRef(r) : new UriRef(ns + m.group(2));
    }

    private static boolean isRelative(String u) {
        int colon = u.indexOf(58);
        if (colon < 0) {
            return true;
        }
        for (int c = 0; c < colon; ++c) {
            if (Character.isLetterOrDigit(u.charAt(c))) continue;
            return true;
        }
        return false;
    }

    private final void Query() throws ParseException {
        this.Prologue();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.SelectQuery();
                break;
            }
            case 17: {
                this.ConstructQuery();
                break;
            }
            case 23: {
                this.DescribeQuery();
                break;
            }
            case 30: {
                this.AskQuery();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(0);
    }

    private final void Prologue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.BaseDecl();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block6;
                }
            }
            this.PrefixDecl();
        }
    }

    private final void BaseDecl() throws ParseException {
        this.jj_consume_token(9);
        Token iriRef = this.jj_consume_token(66);
        this.base = JavaCCGeneratedQueryParser.unquote(iriRef.image);
    }

    private final void PrefixDecl() throws ParseException {
        this.jj_consume_token(16);
        Token ns = this.jj_consume_token(67);
        Token iriRef = this.jj_consume_token(66);
        String pfx = ns.image;
        this.prefixes.put(pfx.substring(0, pfx.length() - 1), JavaCCGeneratedQueryParser.unquote(iriRef.image));
    }

    private final void SelectQuery() throws ParseException {
        this.jj_consume_token(8);
        this.query = new SimpleSelectQuery();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: 
            case 35: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 31: {
                        this.jj_consume_token(31);
                        ((SimpleSelectQuery)this.query).setDistinct();
                        break block0;
                    }
                    case 35: {
                        this.jj_consume_token(35);
                        ((SimpleSelectQuery)this.query).setReduced();
                        break block0;
                    }
                }
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: 
            case 71: {
                block17: while (true) {
                    Variable v = this.Var();
                    ((SimpleSelectQuery)this.query).addSelection(v);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 70: 
                        case 71: {
                            continue block17;
                        }
                    }
                    break;
                }
                this.jj_la1[5] = this.jj_gen;
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                ((SimpleSelectQuery)this.query).setSelectAll();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block18;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
        this.SolutionModifier();
    }

    private final void ConstructQuery() throws ParseException {
        Set<TriplePattern> triplePatterns = null;
        this.jj_consume_token(17);
        triplePatterns = this.ConstructTemplate();
        this.query = new SimpleConstructQuery(triplePatterns);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
        this.SolutionModifier();
    }

    private final void DescribeQuery() throws ParseException {
        this.jj_consume_token(23);
        this.query = new SimpleDescribeQuery();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: {
                block13: while (true) {
                    UriRefOrVariable node = this.VarOrIRIref();
                    ((SimpleDescribeQuery)this.query).addResourceToDescribe(node);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 66: 
                        case 67: 
                        case 68: 
                        case 70: 
                        case 71: {
                            continue block13;
                        }
                    }
                    break;
                }
                this.jj_la1[9] = this.jj_gen;
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                ((SimpleDescribeQuery)this.query).setDescribeAll();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block14;
                }
            }
            this.DatasetClause();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: 
            case 43: {
                this.WhereClause();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.SolutionModifier();
    }

    private final void AskQuery() throws ParseException {
        this.jj_consume_token(30);
        this.query = new SimpleAskQuery();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
    }

    private final void DatasetClause() throws ParseException {
        this.jj_consume_token(12);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: 
            case 67: 
            case 68: {
                this.DefaultGraphClause();
                break;
            }
            case 19: {
                this.NamedGraphClause();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final void DefaultGraphClause() throws ParseException {
        UriRef defaultGraph = this.SourceSelector();
        ((SimpleQuery)this.query).addDefaultGraph(defaultGraph);
    }

    private final void NamedGraphClause() throws ParseException {
        this.jj_consume_token(19);
        UriRef namedGraph = this.SourceSelector();
        ((SimpleQuery)this.query).addNamedGraph(namedGraph);
    }

    private final UriRef SourceSelector() throws ParseException {
        UriRef graph = this.IRIref();
        return graph;
    }

    private final void WhereClause() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        GroupGraphPattern queryPattern = this.GroupGraphPattern();
        ((SimpleQuery)this.query).setQueryPattern(queryPattern);
    }

    private final void SolutionModifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.OrderClause();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: 
            case 24: {
                this.LimitOffsetClauses();
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
    }

    private final void LimitOffsetClauses() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.LimitClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.OffsetClause();
                        break block0;
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                break;
            }
            case 24: {
                this.OffsetClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        this.LimitClause();
                        break block0;
                    }
                }
                this.jj_la1[19] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final void OrderClause() throws ParseException {
        this.jj_consume_token(10);
        this.jj_consume_token(11);
        block3: while (true) {
            this.OrderCondition();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: 
                case 15: 
                case 21: 
                case 22: 
                case 27: 
                case 28: 
                case 29: 
                case 33: 
                case 34: 
                case 36: 
                case 38: 
                case 41: 
                case 42: 
                case 46: 
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 71: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[21] = this.jj_gen;
    }

    private final void OrderCondition() throws ParseException {
        Expression e;
        boolean asc = true;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: 
            case 42: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 41: {
                        this.jj_consume_token(41);
                        break;
                    }
                    case 42: {
                        this.jj_consume_token(42);
                        asc = false;
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                e = this.BrackettedExpression();
                break;
            }
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 46: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 15: 
                    case 21: 
                    case 22: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 33: 
                    case 34: 
                    case 36: 
                    case 38: 
                    case 46: 
                    case 66: 
                    case 67: 
                    case 68: {
                        e = this.Constraint();
                        break block0;
                    }
                    case 70: 
                    case 71: {
                        e = this.Var();
                        break block0;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ((SimpleQueryWithSolutionModifier)this.query).addOrderCondition(new SimpleOrderCondition(e, asc));
    }

    private final void LimitClause() throws ParseException {
        this.jj_consume_token(18);
        Token t = this.jj_consume_token(76);
        ((SimpleQueryWithSolutionModifier)this.query).setLimit(Integer.parseInt(t.image));
    }

    private final void OffsetClause() throws ParseException {
        this.jj_consume_token(24);
        Token t = this.jj_consume_token(76);
        ((SimpleQueryWithSolutionModifier)this.query).setOffset(Integer.parseInt(t.image));
    }

    private final GroupGraphPattern GroupGraphPattern() throws ParseException {
        SimpleGroupGraphPattern groupGraphPattern = new SimpleGroupGraphPattern();
        this.jj_consume_token(43);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: 
            case 39: 
            case 46: 
            case 51: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: {
                this.TriplesBlock(groupGraphPattern);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 20: 
                case 32: 
                case 43: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block16;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 20: 
                case 43: {
                    this.GraphPatternNotTriples(groupGraphPattern);
                    break;
                }
                case 32: {
                    Expression constraint = this.Filter();
                    groupGraphPattern.addConstraint(constraint);
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 44: {
                    this.jj_consume_token(44);
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: 
                case 39: 
                case 46: 
                case 51: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 91: 
                case 93: {
                    this.TriplesBlock(groupGraphPattern);
                    continue block16;
                }
            }
            this.jj_la1[29] = this.jj_gen;
        }
        this.jj_consume_token(45);
        return groupGraphPattern;
    }

    private final void TriplesBlock(GroupGraphPattern groupGraphPattern) throws ParseException {
        Set<TriplePattern> triplePatterns = this.TriplesSameSubject();
        ((SimpleGroupGraphPattern)groupGraphPattern).addTriplePatterns(triplePatterns);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                this.jj_consume_token(44);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 37: 
                    case 39: 
                    case 46: 
                    case 51: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: {
                        this.TriplesBlock(groupGraphPattern);
                        break block0;
                    }
                }
                this.jj_la1[30] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
    }

    private final void GraphPatternNotTriples(GroupGraphPattern groupGraphPattern) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.OptionalGraphPattern(groupGraphPattern);
                break;
            }
            case 43: {
                this.GroupOrUnionGraphPattern(groupGraphPattern);
                break;
            }
            case 13: {
                this.GraphGraphPattern(groupGraphPattern);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final void OptionalGraphPattern(GroupGraphPattern groupGraphPattern) throws ParseException {
        this.jj_consume_token(20);
        GroupGraphPattern optional = this.GroupGraphPattern();
        ((SimpleGroupGraphPattern)groupGraphPattern).addOptionalGraphPattern(optional);
    }

    private final void GraphGraphPattern(GroupGraphPattern groupGraphPattern) throws ParseException {
        this.jj_consume_token(13);
        UriRefOrVariable graph = this.VarOrIRIref();
        GroupGraphPattern g = this.GroupGraphPattern();
        ((SimpleGroupGraphPattern)groupGraphPattern).addGraphPattern(new SimpleGraphGraphPattern(graph, g));
    }

    private final void GroupOrUnionGraphPattern(GroupGraphPattern groupGraphPattern) throws ParseException {
        SimpleAlternativeGraphPattern unionGraphPattern = null;
        GroupGraphPattern g = this.GroupGraphPattern();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: {
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(26);
            if (unionGraphPattern == null) {
                unionGraphPattern = new SimpleAlternativeGraphPattern(g);
            }
            g = this.GroupGraphPattern();
            ((SimpleAlternativeGraphPattern)unionGraphPattern).addAlternativeGraphPattern(g);
        }
        if (unionGraphPattern != null) {
            ((SimpleGroupGraphPattern)groupGraphPattern).addGraphPattern(unionGraphPattern);
        } else {
            ((SimpleGroupGraphPattern)groupGraphPattern).addGraphPattern(g);
        }
    }

    private final Expression Filter() throws ParseException {
        this.jj_consume_token(32);
        Expression c = this.Constraint();
        return c;
    }

    private final Expression Constraint() throws ParseException {
        Expression c;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                c = this.BrackettedExpression();
                break;
            }
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                c = this.BuiltInCall();
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                c = this.FunctionCall();
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return c;
    }

    private final FunctionCall FunctionCall() throws ParseException {
        UriRef name = this.IRIref();
        List<Expression> arguments = this.ArgList();
        return new FunctionCall(name, arguments);
    }

    private final List<Expression> ArgList() throws ParseException {
        ArrayList<Expression> args = new ArrayList<Expression>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                this.jj_consume_token(91);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                Expression e = this.Expression();
                args.add(e);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 47: {
                            break;
                        }
                        default: {
                            this.jj_la1[35] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(47);
                    e = this.Expression();
                    args.add(e);
                }
                this.jj_consume_token(48);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return args;
    }

    private final Set<TriplePattern> ConstructTemplate() throws ParseException {
        Set<TriplePattern> triplePatterns = null;
        this.jj_consume_token(43);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: 
            case 39: 
            case 46: 
            case 51: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: {
                triplePatterns = this.ConstructTriples();
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        this.jj_consume_token(45);
        return triplePatterns;
    }

    private final Set<TriplePattern> ConstructTriples() throws ParseException {
        Set<TriplePattern> triplePatterns = this.TriplesSameSubject();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                this.jj_consume_token(44);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 37: 
                    case 39: 
                    case 46: 
                    case 51: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: {
                        Set<TriplePattern> t = this.ConstructTriples();
                        triplePatterns.addAll(t);
                        break block0;
                    }
                }
                this.jj_la1[38] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        return triplePatterns;
    }

    private final Set<TriplePattern> TriplesSameSubject() throws ParseException {
        HashSet<TriplePattern> triplePatterns = new HashSet<TriplePattern>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: 
            case 39: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: {
                ResourceOrVariable subject = this.VarOrTerm();
                this.PropertyListNotEmpty(subject, triplePatterns);
                return triplePatterns;
            }
            case 46: 
            case 51: {
                ResourceOrVariable subject = this.TriplesNode(triplePatterns);
                this.PropertyList(subject, triplePatterns);
                return triplePatterns;
            }
        }
        this.jj_la1[40] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final void PropertyListNotEmpty(ResourceOrVariable subject, Set<TriplePattern> triplePatterns) throws ParseException {
        UriRefOrVariable predicate = this.Verb();
        Set<ResourceOrVariable> objects = this.ObjectList(triplePatterns);
        this.addTriplePatterns(triplePatterns, subject, predicate, objects);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 49: {
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(49);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 50: 
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 71: {
                    predicate = this.Verb();
                    objects = this.ObjectList(triplePatterns);
                    this.addTriplePatterns(triplePatterns, subject, predicate, objects);
                    continue block6;
                }
            }
            this.jj_la1[42] = this.jj_gen;
        }
    }

    private final void PropertyList(ResourceOrVariable subject, Set<TriplePattern> triplePatterns) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: {
                this.PropertyListNotEmpty(subject, triplePatterns);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
    }

    private final Set<ResourceOrVariable> ObjectList(Set<TriplePattern> triplePatterns) throws ParseException {
        HashSet<ResourceOrVariable> objects = new HashSet<ResourceOrVariable>();
        ResourceOrVariable object = this.Object(triplePatterns);
        objects.add(object);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 47: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(47);
            object = this.Object(triplePatterns);
            objects.add(object);
        }
        return objects;
    }

    private final ResourceOrVariable Object(Set<TriplePattern> triplePatterns) throws ParseException {
        ResourceOrVariable object = this.GraphNode(triplePatterns);
        return object;
    }

    private final UriRefOrVariable Verb() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: {
                UriRefOrVariable predicate = this.VarOrIRIref();
                return predicate;
            }
            case 50: {
                this.jj_consume_token(50);
                return new UriRefOrVariable(RDF_TYPE);
            }
        }
        this.jj_la1[45] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final ResourceOrVariable TriplesNode(Set<TriplePattern> triplePatterns) throws ParseException {
        ResourceOrVariable subject;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                subject = this.Collection(triplePatterns);
                break;
            }
            case 51: {
                subject = this.BlankNodePropertyList(triplePatterns);
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return subject;
    }

    private final ResourceOrVariable BlankNodePropertyList(Set<TriplePattern> triplePatterns) throws ParseException {
        ResourceOrVariable subject = this.getNewBNode();
        this.jj_consume_token(51);
        this.PropertyListNotEmpty(subject, triplePatterns);
        this.jj_consume_token(52);
        return subject;
    }

    private final ResourceOrVariable Collection(Set<TriplePattern> triplePatterns) throws ParseException {
        ArrayList<ResourceOrVariable> nodes = new ArrayList<ResourceOrVariable>();
        this.jj_consume_token(46);
        block3: while (true) {
            ResourceOrVariable node = this.GraphNode(triplePatterns);
            nodes.add(node);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: 
                case 39: 
                case 46: 
                case 51: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 91: 
                case 93: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[47] = this.jj_gen;
        this.jj_consume_token(48);
        return this.addTriplePatterns(triplePatterns, nodes);
    }

    private final ResourceOrVariable GraphNode(Set<TriplePattern> triplePatterns) throws ParseException {
        ResourceOrVariable node;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: 
            case 39: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: {
                node = this.VarOrTerm();
                break;
            }
            case 46: 
            case 51: {
                node = this.TriplesNode(triplePatterns);
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    private final ResourceOrVariable VarOrTerm() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: 
            case 71: {
                Variable v = this.Var();
                return new ResourceOrVariable(v);
            }
            case 37: 
            case 39: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: {
                ResourceOrVariable r = this.GraphTerm();
                return r;
            }
        }
        this.jj_la1[49] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final UriRefOrVariable VarOrIRIref() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: 
            case 71: {
                Variable var = this.Var();
                return new UriRefOrVariable(var);
            }
            case 66: 
            case 67: 
            case 68: {
                UriRef uriRef = this.IRIref();
                return new UriRefOrVariable(uriRef);
            }
        }
        this.jj_la1[50] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final Variable Var() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: {
                t = this.jj_consume_token(70);
                break;
            }
            case 71: {
                t = this.jj_consume_token(71);
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.getVariable(t.image);
    }

    private final ResourceOrVariable GraphTerm() throws ParseException {
        ResourceOrVariable bNode = null;
        Resource r = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: 
            case 67: 
            case 68: {
                r = this.IRIref();
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                r = this.RDFLiteral();
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                r = this.NumericLiteral();
                break;
            }
            case 37: 
            case 39: {
                r = this.BooleanLiteral();
                break;
            }
            case 69: 
            case 93: {
                bNode = this.BlankNode();
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                r = RDF_NIL;
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (bNode == null) {
            return new ResourceOrVariable(r);
        }
        return bNode;
    }

    private final Expression Expression() throws ParseException {
        Expression e = this.ConditionalOrExpression();
        return e;
    }

    private final Expression ConditionalOrExpression() throws ParseException {
        Expression e = this.ConditionalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 53: {
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(53);
            Expression ae = this.ConditionalAndExpression();
            e = new BinaryOperation("||", e, ae);
        }
        return e;
    }

    private final Expression ConditionalAndExpression() throws ParseException {
        Expression e = this.ValueLogical();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 54: {
                    break;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(54);
            Expression e2 = this.ValueLogical();
            e = new BinaryOperation("&&", e, e2);
        }
        return e;
    }

    private final Expression ValueLogical() throws ParseException {
        Expression e = this.RelationalExpression();
        return e;
    }

    private final Expression RelationalExpression() throws ParseException {
        Expression e = this.NumericExpression();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 55: {
                        this.jj_consume_token(55);
                        Expression e2 = this.NumericExpression();
                        e = new BinaryOperation("=", e, e2);
                        break block0;
                    }
                    case 56: {
                        this.jj_consume_token(56);
                        Expression e2 = this.NumericExpression();
                        e = new BinaryOperation("!=", e, e2);
                        break block0;
                    }
                    case 57: {
                        this.jj_consume_token(57);
                        Expression e2 = this.NumericExpression();
                        e = new BinaryOperation("<", e, e2);
                        break block0;
                    }
                    case 58: {
                        this.jj_consume_token(58);
                        Expression e2 = this.NumericExpression();
                        e = new BinaryOperation(">", e, e2);
                        break block0;
                    }
                    case 59: {
                        this.jj_consume_token(59);
                        Expression e2 = this.NumericExpression();
                        e = new BinaryOperation("<=", e, e2);
                        break block0;
                    }
                    case 60: {
                        this.jj_consume_token(60);
                        Expression e2 = this.NumericExpression();
                        e = new BinaryOperation(">=", e, e2);
                        break block0;
                    }
                }
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
            }
        }
        return e;
    }

    private final Expression NumericExpression() throws ParseException {
        Expression e = this.AdditiveExpression();
        return e;
    }

    private final Expression AdditiveExpression() throws ParseException {
        Expression e;
        block10: {
            e = this.MultiplicativeExpression();
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 61: 
                    case 62: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: {
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                        break block10;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 61: {
                        this.jj_consume_token(61);
                        Expression e2 = this.MultiplicativeExpression();
                        e = new BinaryOperation("+", e, e2);
                        continue block9;
                    }
                    case 62: {
                        this.jj_consume_token(62);
                        Expression e2 = this.MultiplicativeExpression();
                        e = new BinaryOperation("-", e, e2);
                        continue block9;
                    }
                    case 79: 
                    case 80: 
                    case 81: {
                        TypedLiteral l = this.NumericLiteralPositive();
                        e = new BinaryOperation("+", e, new LiteralExpression(l));
                        continue block9;
                    }
                    case 82: 
                    case 83: 
                    case 84: {
                        TypedLiteral l = this.NumericLiteralNegative();
                        e = new BinaryOperation("-", e, new LiteralExpression(l));
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[58] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return e;
    }

    private final Expression MultiplicativeExpression() throws ParseException {
        Expression e;
        block8: {
            e = this.UnaryExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 40: 
                    case 63: {
                        break;
                    }
                    default: {
                        this.jj_la1[59] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 40: {
                        this.jj_consume_token(40);
                        Expression e2 = this.UnaryExpression();
                        e = new BinaryOperation("*", e, e2);
                        continue block7;
                    }
                    case 63: {
                        this.jj_consume_token(63);
                        Expression e2 = this.UnaryExpression();
                        e = new BinaryOperation("/", e, e2);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[60] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return e;
    }

    private final Expression UnaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                Expression e = this.PrimaryExpression();
                return new UnaryOperation("!", e);
            }
            case 61: {
                this.jj_consume_token(61);
                Expression e = this.PrimaryExpression();
                return new UnaryOperation("+", e);
            }
            case 62: {
                this.jj_consume_token(62);
                Expression e = this.PrimaryExpression();
                return new UnaryOperation("-", e);
            }
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 46: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                Expression e = this.PrimaryExpression();
                return e;
            }
        }
        this.jj_la1[61] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final Expression PrimaryExpression() throws ParseException {
        Expression e = null;
        Literal l = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                e = this.BrackettedExpression();
                break;
            }
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                e = this.BuiltInCall();
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                e = this.IRIrefOrFunction();
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                l = this.RDFLiteral();
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                l = this.NumericLiteral();
                break;
            }
            case 37: 
            case 39: {
                l = this.BooleanLiteral();
                break;
            }
            case 70: 
            case 71: {
                e = this.Var();
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (l != null) {
            return new LiteralExpression(l);
        }
        return e;
    }

    private final Expression BrackettedExpression() throws ParseException {
        this.jj_consume_token(46);
        Expression e = this.Expression();
        this.jj_consume_token(48);
        return e;
    }

    private final BuiltInCall BuiltInCall() throws ParseException {
        String name;
        ArrayList<Expression> args = new ArrayList<Expression>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                name = "STR";
                this.jj_consume_token(46);
                Expression e = this.Expression();
                args.add(e);
                this.jj_consume_token(48);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                name = "LANG";
                this.jj_consume_token(46);
                Expression e = this.Expression();
                args.add(e);
                this.jj_consume_token(48);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                name = "LANGMATCHES";
                this.jj_consume_token(46);
                Expression e = this.Expression();
                args.add(e);
                this.jj_consume_token(47);
                e = this.Expression();
                args.add(e);
                this.jj_consume_token(48);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                name = "DATATYPE";
                this.jj_consume_token(46);
                Expression e = this.Expression();
                args.add(e);
                this.jj_consume_token(48);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                name = "BOUND";
                this.jj_consume_token(46);
                Variable e = this.Var();
                args.add(e);
                this.jj_consume_token(48);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                name = "sameTerm";
                this.jj_consume_token(46);
                Expression e = this.Expression();
                args.add(e);
                this.jj_consume_token(47);
                e = this.Expression();
                args.add(e);
                this.jj_consume_token(48);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                name = "isIRI";
                this.jj_consume_token(46);
                Expression e = this.Expression();
                args.add(e);
                this.jj_consume_token(48);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                name = "isURI";
                this.jj_consume_token(46);
                Expression e = this.Expression();
                args.add(e);
                this.jj_consume_token(48);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                name = "isBLANK";
                this.jj_consume_token(46);
                Expression e = this.Expression();
                args.add(e);
                this.jj_consume_token(48);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                name = "isLITERAL";
                this.jj_consume_token(46);
                Expression e = this.Expression();
                args.add(e);
                this.jj_consume_token(48);
                break;
            }
            case 34: {
                BuiltInCall e = this.RegexExpression();
                return e;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new BuiltInCall(name, args);
    }

    private final BuiltInCall RegexExpression() throws ParseException {
        ArrayList<Expression> args = new ArrayList<Expression>();
        Expression e = null;
        this.jj_consume_token(34);
        this.jj_consume_token(46);
        e = this.Expression();
        args.add(e);
        this.jj_consume_token(47);
        e = this.Expression();
        args.add(e);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: {
                this.jj_consume_token(47);
                e = this.Expression();
                args.add(e);
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
            }
        }
        this.jj_consume_token(48);
        return new BuiltInCall("REGEX", args);
    }

    private final Expression IRIrefOrFunction() throws ParseException {
        UriRef uriRef = this.IRIref();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: 
            case 91: {
                List<Expression> args = this.ArgList();
                return new FunctionCall(uriRef, args);
            }
        }
        this.jj_la1[65] = this.jj_gen;
        return new UriRefExpression(uriRef);
    }

    private final Literal RDFLiteral() throws ParseException {
        String s = this.String();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: 
            case 72: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 72: {
                        Token t = this.jj_consume_token(72);
                        return new PlainLiteralImpl(s, new Language(t.image.substring(1)));
                    }
                    case 65: {
                        this.jj_consume_token(65);
                        UriRef type = this.IRIref();
                        return new TypedLiteralImpl(s, type);
                    }
                }
                this.jj_la1[66] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[67] = this.jj_gen;
        return new PlainLiteralImpl(s);
    }

    private final TypedLiteral NumericLiteral() throws ParseException {
        TypedLiteral l;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 76: 
            case 77: 
            case 78: {
                l = this.NumericLiteralUnsigned();
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                l = this.NumericLiteralPositive();
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                l = this.NumericLiteralNegative();
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return l;
    }

    private final TypedLiteral NumericLiteralUnsigned() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 76: {
                Token t = this.jj_consume_token(76);
                return LiteralFactory.getInstance().createTypedLiteral(Long.valueOf(t.image));
            }
            case 77: {
                Token t = this.jj_consume_token(77);
                return LiteralFactory.getInstance().createTypedLiteral(Float.valueOf(t.image));
            }
            case 78: {
                Token t = this.jj_consume_token(78);
                return LiteralFactory.getInstance().createTypedLiteral(Double.valueOf(t.image));
            }
        }
        this.jj_la1[69] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final TypedLiteral NumericLiteralPositive() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: {
                Token t = this.jj_consume_token(79);
                return LiteralFactory.getInstance().createTypedLiteral(Long.valueOf(t.image));
            }
            case 80: {
                Token t = this.jj_consume_token(80);
                return LiteralFactory.getInstance().createTypedLiteral(Float.valueOf(t.image));
            }
            case 81: {
                Token t = this.jj_consume_token(81);
                return LiteralFactory.getInstance().createTypedLiteral(Double.valueOf(t.image));
            }
        }
        this.jj_la1[70] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final TypedLiteral NumericLiteralNegative() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 82: {
                Token t = this.jj_consume_token(82);
                return LiteralFactory.getInstance().createTypedLiteral(Long.valueOf(t.image));
            }
            case 83: {
                Token t = this.jj_consume_token(83);
                return LiteralFactory.getInstance().createTypedLiteral(Float.valueOf(t.image));
            }
            case 84: {
                Token t = this.jj_consume_token(84);
                return LiteralFactory.getInstance().createTypedLiteral(Double.valueOf(t.image));
            }
        }
        this.jj_la1[71] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final TypedLiteral BooleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                return LiteralFactory.getInstance().createTypedLiteral(true);
            }
            case 39: {
                this.jj_consume_token(39);
                return LiteralFactory.getInstance().createTypedLiteral(false);
            }
        }
        this.jj_la1[72] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final String String() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: {
                Token t = this.jj_consume_token(86);
                return JavaCCGeneratedQueryParser.unquote(t.image);
            }
            case 87: {
                Token t = this.jj_consume_token(87);
                return JavaCCGeneratedQueryParser.unquote(t.image);
            }
            case 88: {
                Token t = this.jj_consume_token(88);
                return JavaCCGeneratedQueryParser.unTripleQuote(t.image);
            }
            case 89: {
                Token t = this.jj_consume_token(89);
                return JavaCCGeneratedQueryParser.unTripleQuote(t.image);
            }
        }
        this.jj_la1[73] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final UriRef IRIref() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: {
                Token t = this.jj_consume_token(66);
                return this.createUriRef(JavaCCGeneratedQueryParser.unquote(t.image));
            }
            case 67: 
            case 68: {
                UriRef uriRef = this.PrefixedName();
                return uriRef;
            }
        }
        this.jj_la1[74] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final UriRef PrefixedName() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                t = this.jj_consume_token(68);
                break;
            }
            case 67: {
                t = this.jj_consume_token(67);
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.createUriRef(t.image);
    }

    private final ResourceOrVariable BlankNode() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: {
                Token t = this.jj_consume_token(69);
                return this.getBNode(t.image);
            }
            case 93: {
                this.jj_consume_token(93);
                return this.getNewBNode();
            }
        }
        this.jj_la1[76] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1082261760, 512, 65536, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 4096, 4096, 0, 0, 4096, 0x2000000, 4096, 524288, 0x2000000, 1024, 0x1040000, 0x1000000, 262144, 0x1040000, 945864704, 0, 945864704, 945864704, 0, 0x102000, 0x102000, 0, 0, 0, 0, 0x102000, 0x4000000, 945864704, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 945864704, 945864704, 945864704, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 8, 8, 0, 256, 0, 0, 0, 256, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 18006, 1536, 16470, 18006, 540832, 2049, 2049, 4096, 540832, 540832, 4096, 2048, 0, 16470, 32768, 16384, 540832, 540832, 4096, 540832, 131072, 262144, 262144, 32768, 262144, 540672, 540832, 540832, 160, 0, 0, 160, 0x200000, 0x400000, 528482304, 528482304, 0x60000000, 0x60000000, -2147483392, -2147483392, 1610629366, 16630, 86, 32768, 16384, 0, 0, 0, 0, 0, 0, 160, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 192, 192, 0, 0, 220, 220, 0, 0, 0, 28, 0, 0, 0, 0, 0, 0, 220, 0, 220, 220, 736096508, 0, 0, 0, 736096508, 736096508, 0, 0, 0, 28, 0, 0x8000000, 736096508, 736096508, 0, 736096508, 0, 220, 220, 0, 220, 0, 736096508, 736096508, 736096508, 220, 192, 736096316, 0, 0, 0, 0, 2064384, 2064384, 0, 0, 65007837, 65007836, 0, 0, 0x8000000, 258, 258, 0x1FF000, 28672, 229376, 0x1C0000, 0, 0x3C00000, 28, 24, 0x20000020};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public JavaCCGeneratedQueryParser(InputStream stream) {
        this(stream, null);
    }

    public JavaCCGeneratedQueryParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JavaCCGeneratedQueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 77; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 77; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public JavaCCGeneratedQueryParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new JavaCCGeneratedQueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 77; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 77; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public JavaCCGeneratedQueryParser(JavaCCGeneratedQueryParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 77; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(JavaCCGeneratedQueryParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 77; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[100];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 77; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 100; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        JavaCCGeneratedQueryParser.jj_la1_init_0();
        JavaCCGeneratedQueryParser.jj_la1_init_1();
        JavaCCGeneratedQueryParser.jj_la1_init_2();
        JavaCCGeneratedQueryParser.jj_la1_init_3();
    }
}

