/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb.embeddable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.EJBException;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;

public abstract class EJBContainer {
    public static final String APP_NAME = "javax.ejb.embeddable.appName";
    public static final String MODULES = "javax.ejb.embeddable.modules";
    public static final String PROVIDER = "javax.ejb.embeddable.provider";
    private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");
    private static List<EJBContainerProvider> factories = new ArrayList<EJBContainerProvider>();

    public abstract void close();

    public static EJBContainer createEJBContainer() throws EJBException {
        return EJBContainer.createEJBContainer(null);
    }

    public static EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        for (EJBContainerProvider factory : factories) {
            EJBContainer container = factory.createEJBContainer(properties);
            if (container == null) continue;
            return container;
        }
        throw new EJBException("Unable to instantiate container with factories " + factories);
    }

    private static List<String> factoryNamesFromReader(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> names = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            Matcher m = nonCommentPattern.matcher(line = line.trim());
            if (!m.find()) continue;
            names.add(m.group().trim());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findAllFactories() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = loader.getResources("META-INF/services/" + EJBContainerProvider.class.getName());
            HashSet<String> names = new HashSet<String>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream is = url.openStream();
                try {
                    names.addAll(EJBContainer.factoryNamesFromReader(new BufferedReader(new InputStreamReader(is))));
                }
                finally {
                    is.close();
                }
            }
            for (String s : names) {
                Class<?> factoryClass = loader.loadClass(s);
                factories.add((EJBContainerProvider)EJBContainerProvider.class.cast(factoryClass.newInstance()));
            }
        }
        catch (IOException e) {
            throw new EJBException(e);
        }
        catch (InstantiationException e) {
            throw new EJBException(e);
        }
        catch (IllegalAccessException e) {
            throw new EJBException(e);
        }
        catch (ClassNotFoundException e) {
            throw new EJBException(e);
        }
    }

    public abstract Context getContext();

    static {
        EJBContainer.findAllFactories();
    }
}

