/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.support.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInflightRepository
extends ServiceSupport
implements InflightRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInflightRepository.class);
    private final AtomicInteger totalCount = new AtomicInteger();
    private final ConcurrentMap<String, AtomicInteger> routeCount = new ConcurrentHashMap<String, AtomicInteger>();

    @Override
    public void add(Exchange exchange) {
        this.totalCount.incrementAndGet();
    }

    @Override
    public void remove(Exchange exchange) {
        this.totalCount.decrementAndGet();
    }

    @Override
    public void add(Exchange exchange, String routeId) {
        AtomicInteger existing = this.routeCount.putIfAbsent(routeId, new AtomicInteger(1));
        if (existing != null) {
            existing.incrementAndGet();
        }
    }

    @Override
    public void remove(Exchange exchange, String routeId) {
        AtomicInteger existing = (AtomicInteger)this.routeCount.get(routeId);
        if (existing != null) {
            existing.decrementAndGet();
        }
    }

    @Override
    public int size() {
        return this.totalCount.get();
    }

    @Override
    @Deprecated
    public int size(Endpoint endpoint) {
        return 0;
    }

    @Override
    public void removeRoute(String routeId) {
        this.routeCount.remove(routeId);
    }

    @Override
    public int size(String routeId) {
        AtomicInteger existing = (AtomicInteger)this.routeCount.get(routeId);
        return existing != null ? existing.get() : 0;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        int count = this.size();
        if (count > 0) {
            LOG.warn("Shutting down while there are still " + count + " in flight exchanges.");
        } else {
            LOG.debug("Shutting down with no inflight exchanges.");
        }
        this.routeCount.clear();
    }
}

