/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client;

import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.BusErrorCallback;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.slf4j.Logger;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.backend.vfs.impl.LockResult;
import org.uberfire.client.workbench.VFSLockServiceProxy;
import org.uberfire.mvp.ParameterizedCommand;

@Alternative
public class VFSLockServiceProxyBackendImpl
implements VFSLockServiceProxy {
    @Inject
    private Caller<VFSLockService> vfsLockService;
    @Inject
    private Logger logger;

    public void acquireLock(final Path path, final ParameterizedCommand<LockResult> parameterizedCommand) {
        ((VFSLockService)this.vfsLockService.call((RemoteCallback)new RemoteCallback<LockResult>(){

            public void callback(LockResult result) {
                parameterizedCommand.execute((Object)result);
            }
        }, (ErrorCallback)new BusErrorCallback(){

            public boolean error(Message message, Throwable throwable) {
                VFSLockServiceProxyBackendImpl.this.logger.error("Error when trying to acquire lock for " + path.toURI(), throwable);
                parameterizedCommand.execute((Object)LockResult.error());
                return false;
            }
        })).acquireLock(path);
    }

    public void releaseLock(Path path, final ParameterizedCommand<LockResult> parameterizedCommand) {
        ((VFSLockService)this.vfsLockService.call((RemoteCallback)new RemoteCallback<LockResult>(){

            public void callback(LockResult result) {
                parameterizedCommand.execute((Object)result);
            }
        })).releaseLock(path);
    }

    public void retrieveLockInfo(Path path, final ParameterizedCommand<LockInfo> parameterizedCommand) {
        ((VFSLockService)this.vfsLockService.call((RemoteCallback)new RemoteCallback<LockInfo>(){

            public void callback(LockInfo lockInfo) {
                parameterizedCommand.execute((Object)lockInfo);
            }
        })).retrieveLockInfo(path);
    }
}

