/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl.graphmatching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.clerezza.rdf.core.impl.graphmatching.MappingIterator;

class GroupMappingIterator<T, U>
implements Iterator<Map<T, U>> {
    private Iterator<Map<T, U>> firstPartIter;
    private Map<T, U> currentFirstPart;
    private final Map<Set<T>, Set<U>> restMap;
    private Iterator<Map<T, U>> currentRestPartIter;

    static <T, U> Iterator<Map<T, U>> create(Map<Set<T>, Set<U>> matchingGroups) {
        if (matchingGroups.size() > 1) {
            return new GroupMappingIterator<T, U>(matchingGroups);
        }
        if (matchingGroups.size() == 0) {
            return new ArrayList(0).iterator();
        }
        Map.Entry<Set<T>, Set<U>> entry = matchingGroups.entrySet().iterator().next();
        return new MappingIterator<T, U>(entry.getKey(), entry.getValue());
    }

    private GroupMappingIterator(Map<Set<T>, Set<U>> matchingGroups) {
        if (matchingGroups.size() == 0) {
            throw new IllegalArgumentException("matchingGroups must not be empty");
        }
        this.restMap = new HashMap<Set<T>, Set<U>>();
        boolean first = true;
        for (Map.Entry<Set<T>, Set<U>> entry : matchingGroups.entrySet()) {
            if (first) {
                this.firstPartIter = new MappingIterator<T, U>(entry.getKey(), entry.getValue());
                first = false;
                continue;
            }
            this.restMap.put(entry.getKey(), entry.getValue());
        }
        this.currentRestPartIter = GroupMappingIterator.create(this.restMap);
        this.currentFirstPart = this.firstPartIter.next();
    }

    @Override
    public boolean hasNext() {
        return this.firstPartIter.hasNext() || this.currentRestPartIter.hasNext();
    }

    @Override
    public Map<T, U> next() {
        Map<T, U> restPart;
        if (this.currentRestPartIter.hasNext()) {
            restPart = this.currentRestPartIter.next();
        } else if (this.firstPartIter.hasNext()) {
            this.currentFirstPart = this.firstPartIter.next();
            this.currentRestPartIter = GroupMappingIterator.create(this.restMap);
            restPart = this.currentRestPartIter.next();
        } else {
            throw new NoSuchElementException();
        }
        HashMap<T, U> result = new HashMap<T, U>(restPart);
        result.putAll(this.currentFirstPart);
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

