/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql.query;

import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.sparql.query.Variable;

public class ResourceOrVariable {
    private final Resource resource;
    private final Variable variable;

    public ResourceOrVariable(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource: null");
        }
        this.resource = resource;
        this.variable = null;
    }

    public ResourceOrVariable(Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Invalid variable: null");
        }
        this.variable = variable;
        this.resource = null;
    }

    public boolean isVariable() {
        return this.resource == null;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceOrVariable)) {
            return false;
        }
        ResourceOrVariable other = (ResourceOrVariable)obj;
        if (this.isVariable() != other.isVariable()) {
            return false;
        }
        return !(this.isVariable() ? !this.getVariable().equals(other.getVariable()) : !this.getResource().equals(other.getResource()));
    }

    public int hashCode() {
        return this.isVariable() ? 13 * this.getVariable().hashCode() + 7 : 13 * this.getResource().hashCode() + 7;
    }
}

