/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.listbar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.NavbarLink;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jboss.errai.ioc.client.container.IOCResolutionException;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.util.Layouts;
import org.uberfire.client.views.pfly.maximize.MaximizeToggleButton;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.MaximizeToggleButtonPresenter;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.dnd.DragArea;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.listbar.ListBarWidget;
import org.uberfire.client.workbench.widgets.listbar.ListbarPreferences;
import org.uberfire.client.workbench.widgets.listbar.ResizeFocusPanel;
import org.uberfire.commons.data.Pair;
import org.uberfire.mvp.Command;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.menu.EnabledStateChangeListener;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;

@Dependent
public class ListBarWidgetImpl
extends ResizeComposite
implements ListBarWidget {
    public static final String DEBUG_TITLE_PREFIX = "ListBar-title-";
    private static ListBarWidgetBinder uiBinder = (ListBarWidgetBinder)GWT.create(ListBarWidgetBinder.class);
    @Inject
    Instance<ListbarPreferences> optionalListBarPrefs;
    @Inject
    PanelManager panelManager;
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private User identity;
    @UiField
    FocusPanel container;
    @UiField
    SimplePanel title;
    @UiField
    Button contextDisplay;
    @UiField
    FlowPanel header;
    @UiField
    FlowPanel contextMenu;
    @UiField
    Anchor closeButton;
    @UiField
    Anchor dropdownCaret;
    @UiField
    ButtonGroup dropdownCaretContainer;
    @UiField
    DropDownMenu dropdownMenuItems;
    @UiField
    ButtonGroup closeButtonContainer;
    @UiField
    MaximizeToggleButton maximizeButton;
    MaximizeToggleButtonPresenter maximizeButtonPresenter;
    @UiField
    FlowPanel content;
    @UiField
    FlowPanel menuArea;
    WorkbenchPanelPresenter presenter;
    private WorkbenchDragAndDropManager dndManager;
    private final Map<PartDefinition, FlowPanel> partContentView = new HashMap<PartDefinition, FlowPanel>();
    private final Map<PartDefinition, Widget> partTitle = new HashMap<PartDefinition, Widget>();
    LinkedHashSet<PartDefinition> parts = new LinkedHashSet();
    boolean isMultiPart = true;
    boolean isDndEnabled = true;
    Pair<PartDefinition, FlowPanel> currentPart;

    @PostConstruct
    void postConstruct() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.maximizeButton.setVisible(false);
        this.maximizeButtonPresenter = new MaximizeToggleButtonPresenter((MaximizeToggleButtonPresenter.View)this.maximizeButton);
        this.setup(true, true);
        this.dropdownMenuItems.getElement().getStyle().setProperty("left", "auto");
        this.dropdownMenuItems.getElement().getStyle().setProperty("right", "0px");
        this.title.getElement().getStyle().setPosition(Style.Position.RELATIVE);
        this.title.getElement().getStyle().setTop(-5.0, Style.Unit.PX);
        Layouts.setToFillParent((Widget)this);
        this.scheduleResize();
    }

    public void setup(boolean isMultiPart, boolean isDndEnabled) {
        this.isMultiPart = isMultiPart;
        this.isDndEnabled = isDndEnabled;
        this.menuArea.setVisible(false);
        if (isMultiPart) {
            this.closeButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (ListBarWidgetImpl.this.currentPart != null) {
                        ListBarWidgetImpl.this.panelManager.closePart((PartDefinition)ListBarWidgetImpl.this.currentPart.getK1());
                    }
                }
            });
        } else {
            this.dropdownCaretContainer.setVisible(false);
            this.closeButtonContainer.setVisible(false);
        }
        this.container.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                if (ListBarWidgetImpl.this.currentPart != null && ListBarWidgetImpl.this.currentPart.getK1() != null) {
                    ListBarWidgetImpl.this.selectPart((PartDefinition)ListBarWidgetImpl.this.currentPart.getK1());
                }
            }
        });
        if (this.isPropertyListbarContextDisable()) {
            this.contextDisplay.removeFromParent();
        }
        this.content.getElement().getStyle().setPosition(Style.Position.RELATIVE);
        this.content.getElement().getStyle().setTop(0.0, Style.Unit.PX);
        this.content.getElement().getStyle().setLeft(0.0, Style.Unit.PX);
        this.content.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
    }

    boolean isPropertyListbarContextDisable() {
        if (this.optionalListBarPrefs.isUnsatisfied()) {
            return true;
        }
        try {
            return ((ListbarPreferences)this.optionalListBarPrefs.get()).isContextEnabled();
        }
        catch (IOCResolutionException e) {
            return true;
        }
    }

    public void enableDnd() {
        this.isDndEnabled = true;
    }

    public void setExpanderCommand(final Command command) {
        if (!this.isPropertyListbarContextDisable()) {
            this.contextDisplay.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    command.execute();
                }
            });
        }
    }

    public void setPresenter(WorkbenchPanelPresenter presenter) {
        this.presenter = presenter;
    }

    public void setDndManager(WorkbenchDragAndDropManager dndManager) {
        this.dndManager = dndManager;
    }

    public void clear() {
        this.contextMenu.clear();
        this.menuArea.setVisible(false);
        this.title.clear();
        this.content.clear();
        this.parts.clear();
        this.partContentView.clear();
        this.partTitle.clear();
        this.currentPart = null;
        this.dropdownMenuItems.clear();
    }

    public void addPart(WorkbenchPartPresenter.View view) {
        PartDefinition partDefinition = view.getPresenter().getDefinition();
        if (this.parts.contains(partDefinition)) {
            this.selectPart(partDefinition);
            return;
        }
        this.menuArea.setVisible(true);
        this.parts.add(partDefinition);
        FlowPanel panel = new FlowPanel();
        Layouts.setToFillParent((Widget)panel);
        panel.add((IsWidget)view);
        this.content.add((Widget)panel);
        this.partContentView.put(partDefinition, panel);
        Widget title = this.buildTitle(view.getPresenter().getTitle(), view.getPresenter().getTitleDecoration());
        this.partTitle.put(partDefinition, title);
        title.ensureDebugId(DEBUG_TITLE_PREFIX + view.getPresenter().getTitle());
        if (this.isDndEnabled) {
            this.dndManager.makeDraggable((IsWidget)view, (IsWidget)title);
        }
        this.scheduleResize();
    }

    private void updateBreadcrumb(PartDefinition partDefinition) {
        this.title.clear();
        Widget title = this.partTitle.get(partDefinition);
        this.title.add(title);
    }

    private Widget buildTitle(String title, IsWidget titleDecoration) {
        final SpanElement spanElement = Document.get().createSpanElement();
        spanElement.getStyle().setWhiteSpace(Style.WhiteSpace.NOWRAP);
        spanElement.getStyle().setOverflow(Style.Overflow.HIDDEN);
        spanElement.getStyle().setTextOverflow(Style.TextOverflow.ELLIPSIS);
        spanElement.getStyle().setDisplay(Style.Display.BLOCK);
        String titleWidget = titleDecoration instanceof Image ? titleDecoration.toString() : "";
        spanElement.setInnerHTML(titleWidget + " " + title.replaceAll(" ", "\u00a0"));
        return new DragArea(){
            {
                this.add((Element)spanElement);
            }
        };
    }

    public void changeTitle(PartDefinition part, String title, IsWidget titleDecoration) {
        Widget _title = this.buildTitle(title, titleDecoration);
        this.partTitle.put(part, _title);
        if (this.isDndEnabled) {
            this.dndManager.makeDraggable((IsWidget)this.partContentView.get(part), (IsWidget)_title);
        }
        this.setupDropdown();
        if (this.currentPart != null && ((PartDefinition)this.currentPart.getK1()).equals(part)) {
            this.updateBreadcrumb(part);
        }
    }

    public boolean selectPart(PartDefinition part) {
        if (!this.parts.contains(part)) {
            return false;
        }
        if (this.currentPart != null) {
            if (((PartDefinition)this.currentPart.getK1()).equals(part)) {
                return true;
            }
            this.parts.add((PartDefinition)this.currentPart.getK1());
            ((FlowPanel)this.currentPart.getK2()).getElement().getStyle().setDisplay(Style.Display.NONE);
        }
        this.currentPart = Pair.newPair((Object)part, (Object)this.partContentView.get(part));
        ((FlowPanel)this.currentPart.getK2()).getElement().getStyle().setDisplay(Style.Display.BLOCK);
        this.updateBreadcrumb(part);
        this.parts.remove(this.currentPart.getK1());
        this.setupDropdown();
        this.setupContextMenu();
        this.scheduleResize();
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)part);
        return true;
    }

    private void setupDropdown() {
        if (this.isMultiPart) {
            this.dropdownCaretContainer.setVisible(true);
            this.refillPartChooserList();
        } else {
            this.dropdownCaretContainer.setVisible(false);
        }
    }

    private void setupContextMenu() {
        this.contextMenu.clear();
        WorkbenchPartPresenter.View part = (WorkbenchPartPresenter.View)((FlowPanel)this.currentPart.getK2()).getWidget(0);
        if (part.getPresenter().getMenus() != null && part.getPresenter().getMenus().getItems().size() > 0) {
            for (MenuItem menuItem : part.getPresenter().getMenus().getItems()) {
                Widget result = this.makeItem(menuItem, true);
                if (result == null) continue;
                ButtonGroup bg = new ButtonGroup();
                bg.add(result);
                this.contextMenu.add((Widget)bg);
            }
        }
    }

    public boolean remove(PartDefinition part) {
        if (((PartDefinition)this.currentPart.getK1()).equals(part)) {
            if (this.parts.size() > 0) {
                this.presenter.selectPart((PartDefinition)this.parts.iterator().next());
            } else {
                this.clear();
            }
        }
        boolean removed = this.parts.remove(part);
        FlowPanel view = this.partContentView.remove(part);
        if (view != null) {
            this.content.remove((Widget)view);
        }
        this.partTitle.remove(part);
        this.setupDropdown();
        this.scheduleResize();
        return removed;
    }

    public void setFocus(boolean hasFocus) {
    }

    public void addOnFocusHandler(Command command) {
    }

    public int getPartsSize() {
        if (this.currentPart == null) {
            return 0;
        }
        return this.parts.size() + 1;
    }

    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<PartDefinition> handler) {
        return this.addHandler((EventHandler)handler, BeforeSelectionEvent.getType());
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<PartDefinition> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public void onResize() {
        if (!this.isAttached()) {
            return;
        }
        int contentHeight = this.getOffsetHeight() - this.header.getOffsetHeight();
        if (contentHeight < 0) {
            this.content.getElement().getStyle().setHeight(100.0, Style.Unit.PCT);
        } else {
            this.content.getElement().getStyle().setHeight((double)contentHeight, Style.Unit.PX);
        }
        super.onResize();
        for (int i = 0; i < this.content.getWidgetCount(); ++i) {
            FlowPanel container = (FlowPanel)this.content.getWidget(i);
            Widget containedWidget = container.getWidget(0);
            if (!(containedWidget instanceof RequiresResize)) continue;
            ((RequiresResize)containedWidget).onResize();
        }
    }

    private Widget makeItem(MenuItem item, boolean isRoot) {
        Object result;
        if (!this.authzManager.authorize((Resource)item, this.identity)) {
            return null;
        }
        if (item instanceof MenuItemCommand) {
            final MenuItemCommand cmdItem = (MenuItemCommand)item;
            if (isRoot) {
                final Button button = new Button(cmdItem.getCaption());
                button.setSize(ButtonSize.EXTRA_SMALL);
                button.setEnabled(item.isEnabled());
                button.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        cmdItem.getCommand().execute();
                    }
                });
                item.addEnabledStateChangeListener(new EnabledStateChangeListener(){

                    public void enabledStateChanged(boolean enabled) {
                        button.setEnabled(enabled);
                    }
                });
                return button;
            }
            final NavbarLink navbarLink = new NavbarLink();
            navbarLink.setText(cmdItem.getCaption());
            if (!item.isEnabled()) {
                navbarLink.addStyleName("disabled");
            }
            navbarLink.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    cmdItem.getCommand().execute();
                }
            });
            item.addEnabledStateChangeListener(new EnabledStateChangeListener(){

                public void enabledStateChanged(boolean enabled) {
                    if (enabled) {
                        navbarLink.removeStyleName("disabled");
                    } else {
                        navbarLink.addStyleName("disabled");
                    }
                }
            });
            return navbarLink;
        }
        if (item instanceof MenuGroup) {
            MenuGroup groups = (MenuGroup)item;
            if (isRoot) {
                ArrayList<Widget> widgetList = new ArrayList<Widget>();
                for (MenuItem _item : groups.getItems()) {
                    Widget widget = this.makeItem(_item, false);
                    if (widget == null) continue;
                    widgetList.add(widget);
                }
                if (widgetList.isEmpty()) {
                    return null;
                }
                return this.makeDropDownMenuButton(groups.getCaption(), widgetList);
            }
            ArrayList<Widget> widgetList = new ArrayList<Widget>();
            for (MenuItem _item : groups.getItems()) {
                Widget result2 = this.makeItem(_item, false);
                if (result2 == null) continue;
                widgetList.add(result2);
            }
            if (widgetList.isEmpty()) {
                return null;
            }
            return this.makeDropDownMenuButton(groups.getCaption(), widgetList);
        }
        if (item instanceof MenuCustom && (result = ((MenuCustom)item).build()) instanceof Widget) {
            return (Widget)result;
        }
        return null;
    }

    private Widget makeDropDownMenuButton(String caption, List<Widget> widgetList) {
        ButtonGroup buttonGroup = new ButtonGroup();
        Button dropdownButton = new Button(caption);
        dropdownButton.setDataToggle(Toggle.DROPDOWN);
        dropdownButton.setSize(ButtonSize.EXTRA_SMALL);
        DropDownMenu dropDownMenu = new DropDownMenu();
        for (Widget _item : widgetList) {
            dropDownMenu.add(_item);
        }
        buttonGroup.add((Widget)dropdownButton);
        buttonGroup.add((Widget)dropDownMenu);
        return buttonGroup;
    }

    private void refillPartChooserList() {
        this.dropdownMenuItems.clear();
        if (this.currentPart != null) {
            String ctitle = ((WorkbenchPartPresenter.View)this.partContentView.get(this.currentPart.getK1()).getWidget(0)).getPresenter().getTitle();
            AnchorListItem currentPartEntry = new AnchorListItem(ctitle);
            this.dropdownMenuItems.add((Widget)currentPartEntry);
            for (final PartDefinition part : this.parts) {
                String title = ((WorkbenchPartPresenter.View)this.partContentView.get(part).getWidget(0)).getPresenter().getTitle();
                AnchorListItem selectPartEntry = new AnchorListItem(title);
                selectPartEntry.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ListBarWidgetImpl.this.selectPart(part);
                    }
                });
                this.dropdownMenuItems.add((Widget)selectPartEntry);
            }
        }
    }

    private void scheduleResize() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                ListBarWidgetImpl.this.onResize();
            }
        });
    }

    public MaximizeToggleButtonPresenter getMaximizeButton() {
        return this.maximizeButtonPresenter;
    }

    public boolean isMultiPart() {
        return this.isMultiPart;
    }

    public boolean isDndEnabled() {
        return this.isDndEnabled;
    }

    static interface ListBarWidgetBinder
    extends UiBinder<ResizeFocusPanel, ListBarWidgetImpl> {
    }
}

