/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorButton;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.ListItem;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.gwtbootstrap3.client.ui.html.Span;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@ApplicationScoped
public class UserMenu
extends ListItem {
    @Inject
    private User user;
    private final DropDownMenu menu = new DropDownMenu();

    @PostConstruct
    private void setup() {
        AnchorButton mainContent = new AnchorButton(ButtonType.DEFAULT);
        mainContent.removeStyleName("btn");
        mainContent.removeStyleName(ButtonType.DEFAULT.getCssName());
        Span userIcon = new Span();
        userIcon.addStyleName("pficon");
        userIcon.addStyleName("pficon-user");
        mainContent.add((Widget)userIcon);
        mainContent.add((Widget)new Text(this.formattedUsername()));
        mainContent.setDataToggle(Toggle.DROPDOWN);
        this.addStyleName("dropdown");
        this.add((Widget)mainContent);
        this.add((Widget)this.menu);
    }

    public DropDownMenu getMenu() {
        return this.menu;
    }

    private String formattedUsername() {
        StringBuilder sb = new StringBuilder();
        if (this.user.getProperty("org.jboss.errai.security.FIRST_NAME") != null) {
            sb.append(this.user.getProperty("org.jboss.errai.security.FIRST_NAME"));
        }
        if (this.user.getProperty("org.jboss.errai.security.LAST_NAME") != null) {
            sb.append(" ");
            sb.append(this.user.getProperty("org.jboss.errai.security.LAST_NAME"));
        }
        if (sb.length() == 0) {
            sb.append(this.user.getIdentifier());
        }
        return sb.toString();
    }

    public class Builder
    implements MenuFactory.CustomMenuBuilder {
        public void push(MenuFactory.CustomMenuBuilder element) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public MenuItem build() {
            return new BaseMenuCustom<UserMenu>(){

                public UserMenu build() {
                    return (UserMenu)((Object)IOC.getBeanManager().lookupBean(UserMenu.class, new Annotation[0]).getInstance());
                }

                public void accept(MenuVisitor visitor) {
                    visitor.visit((MenuCustom)this);
                }
            };
        }
    }
}

